/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spf4j.base.Pair;
import org.spf4j.base.Throwables;
import org.spf4j.base.TimeSource;

public final class Futures {
    private Futures() {
    }

    @Nullable
    @CheckReturnValue
    public static RuntimeException cancelAll(boolean mayInterrupt, Future<?> ... futures) {
        return Futures.cancelAll(mayInterrupt, (Future[])futures, 0);
    }

    @Nullable
    @CheckReturnValue
    public static RuntimeException cancelAll(boolean mayInterrupt, Future[] futures, int from) {
        RuntimeException ex = null;
        for (int i = from; i < futures.length; ++i) {
            Future future = futures[i];
            try {
                future.cancel(mayInterrupt);
                continue;
            }
            catch (RuntimeException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                Throwables.suppressLimited(ex, e);
            }
        }
        return ex;
    }

    @Nullable
    public static RuntimeException cancelAll(boolean mayInterrupt, Iterator<Future<?>> iterator) {
        RuntimeException ex = null;
        while (iterator.hasNext()) {
            Future<?> future = iterator.next();
            try {
                future.cancel(mayInterrupt);
            }
            catch (RuntimeException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                Throwables.suppressLimited(ex, e);
            }
        }
        return ex;
    }

    @CheckReturnValue
    @Nonnull
    public static Pair<Map<Future, Object>, Exception> getAll(long timeoutMillis, Future ... futures) {
        long deadlineNanos = TimeSource.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        return Futures.getAllWithDeadlineNanos(deadlineNanos, futures);
    }

    @CheckReturnValue
    @Nonnull
    public static Pair<Map<Future, Object>, Exception> getAllWithDeadlineNanos(long deadlineNanos, Future ... futures) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)futures.length);
        Exception ex = Futures.getAllWithDeadlineNanos(deadlineNanos, res::put, futures);
        return Pair.of(res, ex);
    }

    @CheckReturnValue
    @Nullable
    public static <T> Exception getAllWithDeadlineNanos(long deadlineNanos, BiConsumer<Future<T>, T> consumer, Future<T> ... futures) {
        Exception exception = null;
        for (int i = 0; i < futures.length; ++i) {
            Future<T> future = futures[i];
            try {
                long toNanos = deadlineNanos - TimeSource.nanoTime();
                T get = future.get(Math.max(0L, toNanos), TimeUnit.NANOSECONDS);
                consumer.accept((Future<Future<T>>)future, (Future<T>)get);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                if (exception == null) {
                    exception = ex;
                } else {
                    Throwables.suppressLimited(ex, exception);
                    exception = ex;
                }
                RuntimeException cex = Futures.cancelAll(true, (Future[])futures, i + 1);
                if (cex == null) continue;
                Throwables.suppressLimited(exception, cex);
                continue;
            }
            catch (TimeoutException ex) {
                try {
                    future.cancel(true);
                }
                catch (RuntimeException ex2) {
                    ex.addSuppressed(ex2);
                }
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                Throwables.suppressLimited(exception, ex);
                continue;
            }
            catch (RuntimeException | ExecutionException ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                Throwables.suppressLimited(exception, ex);
            }
        }
        return exception;
    }

    @CheckReturnValue
    @Nullable
    public static Exception getAllWithDeadlineNanosRetVoid(long deadlineNanos, Future ... futures) {
        return Futures.getAllWithDeadlineNanos(deadlineNanos, (Future<T> a, T b) -> {}, futures);
    }

    @CheckReturnValue
    @Nonnull
    public static Pair<Map<Future, Object>, Exception> getAll(long timeoutMillis, Iterable<Future> futures) {
        long deadlineNanos = TimeSource.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        return Futures.getAllWithDeadlineNanos(deadlineNanos, futures);
    }

    @CheckReturnValue
    @Nonnull
    public static Pair<Map<Future, Object>, Exception> getAllWithDeadlineNanos(long deadlineNanos, Iterable<Future> futures) {
        HashMap results = futures instanceof Collection ? Maps.newHashMapWithExpectedSize((int)((Collection)futures).size()) : new HashMap();
        Exception ex = Futures.getAllWithDeadlineNanos(deadlineNanos, results::put, futures);
        return Pair.of(results, ex);
    }

    @CheckReturnValue
    @Nullable
    public static <T> Exception getAllWithDeadlineNanos(long deadlineNanos, BiConsumer<Future<T>, T> consumer, Iterable<Future<T>> futures) {
        Exception exception = null;
        Iterator<Future<?>> iterator = futures.iterator();
        while (iterator.hasNext()) {
            Future<T> future = iterator.next();
            try {
                long toNanos = deadlineNanos - TimeSource.nanoTime();
                T get = future.get(Math.max(0L, toNanos), TimeUnit.NANOSECONDS);
                consumer.accept((Future<Future<T>>)future, (Future<T>)get);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                if (exception == null) {
                    exception = ex;
                } else {
                    Throwables.suppressLimited(ex, exception);
                    exception = ex;
                }
                RuntimeException cex = Futures.cancelAll(true, iterator);
                if (cex == null) break;
                Throwables.suppressLimited(exception, cex);
                break;
            }
            catch (TimeoutException ex) {
                try {
                    future.cancel(true);
                }
                catch (RuntimeException ex2) {
                    ex.addSuppressed(ex2);
                }
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                Throwables.suppressLimited(exception, ex);
            }
            catch (RuntimeException | ExecutionException ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                Throwables.suppressLimited(exception, ex);
            }
        }
        return exception;
    }

    public static <T> List<Future<T>> timedOutFutures(int copies, final TimeoutException ex) {
        Future fut = new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public T get() throws ExecutionException {
                throw new ExecutionException(ex);
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws TimeoutException {
                throw ex;
            }
        };
        return Collections.nCopies(copies, fut);
    }
}

