/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.TimeSource;
import org.spf4j.base.Timing;
import org.spf4j.base.UncheckedExecutionException;
import org.spf4j.concurrent.MutableLifoThreadPool;
import org.spf4j.concurrent.RejectedExecutionHandler;
import org.spf4j.ds.SimpleStack;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.stackmonitor.StackTrace;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"MDM_THREAD_PRIORITIES", "MDM_WAIT_WITHOUT_TIMEOUT"})
public final class LifoThreadPoolExecutorSQP
extends AbstractExecutorService
implements MutableLifoThreadPool {
    private static final Logger LOG = LoggerFactory.getLogger(LifoThreadPoolExecutorSQP.class);
    private static final long CORE_MINWAIT_NANOS = Long.getLong("spf4j.lifoTp.coreMaxWaitNanos", 1000000000L);
    private static final int LL_THRESHOLD = Integer.getInteger("spf4j.lifoTp.llQueueSizeThreshold", 64000);
    @GuardedBy(value="stateLock")
    private final Queue<Runnable> taskQueue;
    @GuardedBy(value="stateLock")
    private final SimpleStack<QueuedThread> threadQueue;
    @GuardedBy(value="stateLock")
    private int maxIdleTimeMillis;
    @GuardedBy(value="stateLock")
    private int maxThreadCount;
    @GuardedBy(value="stateLock")
    private final PoolState state;
    private final ReentrantLock stateLock;
    private final Condition stateCondition;
    @GuardedBy(value="stateLock")
    private int queueSizeLimit;
    private final String poolName;
    private final RejectedExecutionHandler rejectionHandler;
    @GuardedBy(value="stateLock")
    private boolean daemonThreads;
    @GuardedBy(value="stateLock")
    private int threadPriority;
    private int threadCreationCount;

    public LifoThreadPoolExecutorSQP(int maxNrThreads, String name) {
        this(name, 0, maxNrThreads, 5000, 0);
    }

    public LifoThreadPoolExecutorSQP(String poolName, int coreSize, int maxSize, int maxIdleTimeMillis, int queueSize, boolean daemonThreads) {
        this(poolName, coreSize, maxSize, maxIdleTimeMillis, queueSize, daemonThreads, RejectedExecutionHandler.REJECT_EXCEPTION_EXEC_HANDLER);
    }

    public LifoThreadPoolExecutorSQP(String poolName, int coreSize, int maxSize, int maxIdleTimeMillis, int queueSizeLimit) {
        this(poolName, coreSize, maxSize, maxIdleTimeMillis, queueSizeLimit, false, RejectedExecutionHandler.REJECT_EXCEPTION_EXEC_HANDLER);
    }

    public LifoThreadPoolExecutorSQP(String poolName, int coreSize, int maxSize, int maxIdleTimeMillis, int queueSizeLimit, boolean daemonThreads, RejectedExecutionHandler rejectionHandler) {
        this(poolName, coreSize, maxSize, maxIdleTimeMillis, queueSizeLimit, daemonThreads, rejectionHandler, 5);
    }

    public LifoThreadPoolExecutorSQP(String poolName, int coreSize, int maxSize, int maxIdleTimeMillis, int queueSizeLimit, boolean daemonThreads, RejectedExecutionHandler rejectionHandler, int threadPriority) {
        if (coreSize > maxSize) {
            throw new IllegalArgumentException("Core size must be smaller than max size " + coreSize + " < " + maxSize);
        }
        if (coreSize < 0 || maxSize < 0 || maxIdleTimeMillis < 0 || queueSizeLimit < 0) {
            throw new IllegalArgumentException("All numberic TP configs must be positive values: " + coreSize + ", " + maxSize + ", " + maxIdleTimeMillis + ", " + queueSizeLimit);
        }
        this.stateLock = new ReentrantLock();
        this.rejectionHandler = rejectionHandler;
        this.poolName = poolName;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
        this.taskQueue = new ArrayDeque<Runnable>(Math.min(queueSizeLimit, LL_THRESHOLD));
        this.queueSizeLimit = queueSizeLimit;
        this.threadQueue = new SimpleStack(Math.min(1024, maxSize));
        this.threadPriority = threadPriority;
        this.state = new PoolState(coreSize, (Set<QueuedThread>)new THashSet(Math.min(maxSize, 2048)));
        this.stateCondition = this.stateLock.newCondition();
        this.daemonThreads = daemonThreads;
        for (int i = 0; i < coreSize; ++i) {
            QueuedThread qt = new QueuedThread(poolName + '-' + this.threadCreationCount++, this.threadQueue, this.taskQueue, maxIdleTimeMillis, null, this.state, this.stateLock, this.stateCondition);
            qt.setDaemon(daemonThreads);
            qt.setPriority(threadPriority);
            this.state.addThread(qt);
            qt.start();
        }
        this.maxThreadCount = maxSize;
    }

    @Override
    public void exportJmx() {
        Registry.export(LifoThreadPoolExecutorSQP.class.getName(), this.poolName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT", "MDM_LOCK_ISLOCKED", "UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="no blocking is done while holding the lock, lock is released on all paths, findbugs just cannot figure it out...")
    public void execute(Runnable command) {
        boolean reject = false;
        this.stateLock.lock();
        try {
            if (this.state.isShutdown()) {
                this.stateLock.unlock();
                this.rejectionHandler.rejectedExecution(command, this);
                return;
            }
            QueuedThread nqt = this.threadQueue.pollLast();
            if (nqt != null) {
                nqt.runNext(command);
                this.stateLock.unlock();
                return;
            }
            int tc = this.state.getThreadCount();
            if (tc < this.maxThreadCount) {
                QueuedThread qt;
                try {
                    qt = new QueuedThread(this.poolName + '-' + this.threadCreationCount++, this.threadQueue, this.taskQueue, this.maxIdleTimeMillis, command, this.state, this.stateLock, this.stateCondition);
                    qt.setDaemon(this.daemonThreads);
                    qt.setPriority(this.threadPriority);
                    this.state.addThread(qt);
                }
                finally {
                    this.stateLock.unlock();
                }
                qt.start();
                return;
            }
            reject = this.taskQueue.size() >= this.queueSizeLimit || !this.taskQueue.offer(command);
        }
        catch (Throwable t) {
            if (this.stateLock.isHeldByCurrentThread()) {
                this.stateLock.unlock();
            }
            throw t;
        }
        this.stateLock.unlock();
        if (reject) {
            this.rejectionHandler.rejectedExecution(command, this);
        }
    }

    @Override
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"})
    public void shutdown() {
        this.stateLock.lock();
        try {
            if (!this.state.isShutdown()) {
                QueuedThread th;
                this.state.setShutdown(true);
                while ((th = this.threadQueue.pollLast()) != null) {
                    th.signal();
                }
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        int threadCount;
        long deadlinenanos = TimeSource.nanoTime() + unit.toNanos(time);
        this.stateLock.lock();
        try {
            if (!this.state.isShutdown()) {
                throw new IllegalStateException("Threadpool is not is shutdown mode " + this);
            }
            threadCount = this.state.getThreadCount();
            long timeoutNs = deadlinenanos - TimeSource.nanoTime();
            while (threadCount > 0 && timeoutNs > 0L) {
                timeoutNs = this.stateCondition.awaitNanos(timeoutNs);
                threadCount = this.state.getThreadCount();
            }
        }
        finally {
            this.stateLock.unlock();
        }
        return threadCount == 0;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        this.stateLock.lock();
        try {
            this.state.interruptAll();
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.taskQueue);
            return arrayList;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public boolean isShutdown() {
        this.stateLock.lock();
        try {
            boolean bl = this.state.isShutdown();
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public boolean isDaemonThreads() {
        this.stateLock.lock();
        try {
            boolean bl = this.daemonThreads;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public boolean isTerminated() {
        this.stateLock.lock();
        try {
            boolean bl = this.state.isShutdown() && this.state.getThreadCount() == 0;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public int getThreadCount() {
        this.stateLock.lock();
        try {
            int n = this.state.getThreadCount();
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public int getMaxThreadCount() {
        this.stateLock.lock();
        try {
            int n = this.maxThreadCount;
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public int getCoreThreadCount() {
        this.stateLock.lock();
        try {
            int n = this.state.getCoreThreads();
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public ReentrantLock getStateLock() {
        return this.stateLock;
    }

    @Override
    @JmxExport
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"}, justification="Holders of this lock will not block")
    public int getNrQueuedTasks() {
        this.stateLock.lock();
        try {
            int n = this.taskQueue.size();
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public int getQueueSizeLimit() {
        this.stateLock.lock();
        try {
            int n = this.queueSizeLimit;
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void unregisterJmx() {
        Registry.unregister(LifoThreadPoolExecutorSQP.class.getName(), this.poolName);
    }

    @Override
    @JmxExport
    public void setDaemonThreads(boolean daemonThreads) {
        this.stateLock.lock();
        try {
            this.daemonThreads = daemonThreads;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setMaxIdleTimeMillis(int maxIdleTimeMillis) {
        this.stateLock.lock();
        try {
            this.maxIdleTimeMillis = maxIdleTimeMillis;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setMaxThreadCount(int maxThreadCount) {
        this.stateLock.lock();
        try {
            this.maxThreadCount = maxThreadCount;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setCoreThreadCount(int coreThreadCount) {
        this.stateLock.lock();
        try {
            this.state.setCoreThreads(coreThreadCount);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setQueueSizeLimit(int queueSizeLimit) {
        this.stateLock.lock();
        try {
            this.queueSizeLimit = queueSizeLimit;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public void setThreadPriority(int threadPriority) {
        this.stateLock.lock();
        try {
            this.threadPriority = threadPriority;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public String toString() {
        return "LifoThreadPoolExecutorSQP{threadQueue=" + this.threadQueue + ", maxIdleTimeMillis=" + this.maxIdleTimeMillis + ", maxThreadCount=" + this.maxThreadCount + ", state=" + this.state + ", submitMonitor=" + this.stateLock + ", queueCapacity=" + this.queueSizeLimit + ", poolName=" + this.poolName + '}';
    }

    @Override
    public Queue<Runnable> getTaskQueue() {
        return this.taskQueue;
    }

    @Override
    @JmxExport
    public int getMaxIdleTimeMillis() {
        this.stateLock.lock();
        try {
            int n = this.maxIdleTimeMillis;
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    @JmxExport
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    @JmxExport
    public int getThreadPriority() {
        this.stateLock.lock();
        try {
            int n = this.threadPriority;
            return n;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static final class PoolState {
        private boolean shutdown = false;
        private int coreThreads;
        private final Set<QueuedThread> allThreads;

        PoolState(int thnr, Set<QueuedThread> allThreads) {
            this.coreThreads = thnr;
            this.allThreads = allThreads;
        }

        public void addThread(QueuedThread thread) {
            if (!this.allThreads.add(thread)) {
                throw new IllegalStateException("Attempting to add a thread twice: " + thread);
            }
            LOG.debug("Started thread {}", (Object)thread.getName());
        }

        public void removeThread(QueuedThread thread) {
            if (!this.allThreads.remove(thread)) {
                throw new IllegalStateException("Removing thread failed: " + thread);
            }
            LOG.debug("Terminating thread {}", (Object)thread.getName());
        }

        public void interruptAll() {
            for (Thread thread : this.allThreads) {
                thread.interrupt();
            }
        }

        public int getCoreThreads() {
            return this.coreThreads;
        }

        public void setCoreThreads(int setCoreThreads) {
            this.coreThreads = setCoreThreads;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        public void setShutdown(boolean shutdown) {
            this.shutdown = shutdown;
        }

        public int getThreadCount() {
            return this.allThreads.size();
        }

        public String toString() {
            return "ExecState{shutdown=" + this.shutdown + ", threadCount=" + this.allThreads.size() + '}';
        }
    }

    @SuppressFBWarnings(value={"NO_NOTIFY_NOT_NOTIFYALL"})
    private static final class QueuedThread
    extends Thread {
        private final SimpleStack<QueuedThread> threadQueue;
        private final Queue<Runnable> taskQueue;
        private final int maxIdleTimeMillis;
        @GuardedBy(value="poolStateLock")
        private final PoolState state;
        private long lastRunNanos;
        private final ReentrantLock poolStateLock;
        private final Condition poolStateCondition;
        private final Condition submitCondition;
        @Nullable
        private Runnable toRun;

        QueuedThread(String name, SimpleStack<QueuedThread> threadQueue, Queue<Runnable> taskQueue, int maxIdleTimeMillis, @Nullable Runnable runFirst, PoolState state, ReentrantLock submitMonitor, Condition submitCondition) {
            super(name);
            this.threadQueue = threadQueue;
            this.taskQueue = taskQueue;
            this.maxIdleTimeMillis = maxIdleTimeMillis;
            this.state = state;
            this.lastRunNanos = TimeSource.nanoTime();
            this.poolStateLock = submitMonitor;
            this.submitCondition = submitMonitor.newCondition();
            this.poolStateCondition = submitCondition;
            this.toRun = runFirst;
        }

        @CheckReturnValue
        @SuppressFBWarnings(value={"MDM_SIGNAL_NOT_SIGNALALL"})
        private void runNext(Runnable runnable) {
            this.toRun = runnable;
            this.submitCondition.signal();
        }

        @SuppressFBWarnings
        private void signal() {
            this.runNext(AbstractRunnable.NOP);
        }

        @Override
        public void run() {
            Runnable r = this.toRun;
            if (r != null) {
                try {
                    this.execute(r);
                }
                finally {
                    this.toRun = null;
                }
            }
            this.doRun(TimeUnit.MILLISECONDS.toNanos(this.maxIdleTimeMillis));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"MDM_LOCK_ISLOCKED", "UL_UNRELEASED_LOCK"})
        private void doRun(long maxIdleNanos) {
            try {
                while (true) {
                    int ptr;
                    long timeoutNanos;
                    block20: {
                        this.poolStateLock.lock();
                        Runnable poll = this.taskQueue.poll();
                        if (poll != null) {
                            this.poolStateLock.unlock();
                            this.execute(poll);
                            continue;
                        }
                        if (this.state.isShutdown()) {
                            this.removeThread();
                            break;
                        }
                        timeoutNanos = this.lastRunNanos + maxIdleNanos - TimeSource.nanoTime();
                        if (timeoutNanos <= 0L) {
                            int tc = this.state.getThreadCount();
                            if (tc > this.state.getCoreThreads()) {
                                this.removeThread();
                                break;
                            }
                            timeoutNanos = CORE_MINWAIT_NANOS;
                        }
                        ptr = this.threadQueue.pushAndGetIdx(this);
                        try {
                            timeoutNanos = this.submitCondition.awaitNanos(timeoutNanos);
                        }
                        catch (InterruptedException ex) {
                            if (!this.state.isShutdown()) break block20;
                            this.removeThread();
                            break;
                        }
                    }
                    Runnable r = this.toRun;
                    if (r != null) {
                        this.poolStateLock.unlock();
                        try {
                            this.execute(r);
                        }
                        finally {
                            this.toRun = null;
                        }
                        continue;
                    }
                    QueuedThread qt = (QueuedThread)this.threadQueue.get(ptr);
                    if (qt == this) {
                        this.threadQueue.remove(ptr);
                    } else if (!this.threadQueue.remove(this)) {
                        throw new IllegalStateException("Thread " + this + " not present in " + this.threadQueue);
                    }
                    if (timeoutNanos <= 0L) {
                        int tc = this.state.getThreadCount();
                        if (this.state.isShutdown() || tc > this.state.getCoreThreads()) {
                            this.removeThread();
                            break;
                        }
                    }
                    this.poolStateLock.unlock();
                }
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception", t);
                if (this.poolStateLock.isHeldByCurrentThread()) {
                    this.poolStateLock.unlock();
                }
                throw t;
            }
        }

        private void removeThread() {
            this.state.removeThread(this);
            this.poolStateCondition.signalAll();
            this.poolStateLock.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                Thread.UncaughtExceptionHandler uexh = this.getUncaughtExceptionHandler();
                try {
                    uexh.uncaughtException(this, e);
                }
                catch (RuntimeException ex) {
                    ex.addSuppressed(e);
                    throw new UncheckedExecutionException("Uncaught exception handler blew up: " + uexh, ex);
                }
            }
            finally {
                this.lastRunNanos = TimeSource.nanoTime();
            }
        }

        @Override
        public String toString() {
            Object[] stackTrace;
            try {
                stackTrace = this.getStackTrace();
            }
            catch (RuntimeException ex) {
                stackTrace = StackTrace.EMPTY_STACK_TRACE;
            }
            return "QueuedThread{name = " + this.getName() + ", lastRunNanos=" + Timing.getCurrentTiming().fromNanoTimeToInstant(this.lastRunNanos) + ", stack =" + Arrays.toString(stackTrace) + ", toRun = " + this.toRun + '}';
        }
    }
}

