/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.concurrent.Semaphore;

@ParametersAreNonnullByDefault
@ThreadSafe
public interface PermitSupplier {
    public static final PermitSupplier UNLIMITED = new PermitSupplier(){

        @Override
        public boolean tryAcquire(int nrPermits, long deadlineNanos) {
            return true;
        }

        public String toString() {
            return "Unlimited";
        }
    };
    public static final PermitSupplier EMPTY = new PermitSupplier(){

        @Override
        public boolean tryAcquire(int nrPermits, long deadlineNanos) {
            return false;
        }

        public String toString() {
            return "Empty";
        }
    };

    default public void acquire(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.acquire(1, timeout, unit);
    }

    default public void acquire(int nrPermits, @Nonnegative long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.tryAcquire(nrPermits, timeout, unit)) {
            throw new TimeoutException("Cannot acquire timeout after " + timeout + " " + (Object)((Object)unit));
        }
    }

    @CheckReturnValue
    default public boolean tryAcquire(@Nonnegative long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    @CheckReturnValue
    default public boolean tryAcquire(@Nonnegative int nrPermits, @Nonnegative long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout " + timeout + ' ' + (Object)((Object)unit));
        }
        return this.tryAcquire(nrPermits, ExecutionContexts.computeDeadline(timeout, unit));
    }

    @CheckReturnValue
    public boolean tryAcquire(@Nonnegative int var1, long var2) throws InterruptedException;

    @CheckReturnValue
    default public Acquisition tryAcquireEx(@Nonnegative int nrPermits, @Nonnegative long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout " + timeout + ' ' + (Object)((Object)unit));
        }
        return this.tryAcquireEx(nrPermits, ExecutionContexts.computeDeadline(timeout, unit));
    }

    @CheckReturnValue
    default public Acquisition tryAcquireEx(@Nonnegative int nrPermits, long deadlineNanos) throws InterruptedException {
        boolean res = this.tryAcquire(nrPermits, deadlineNanos);
        if (res) {
            return Acquisition.SUCCESS;
        }
        return Acquisition.failed(-1L);
    }

    default public boolean addPermits(int nrPermits) {
        return false;
    }

    default public Semaphore toSemaphore() {
        return new Semaphore(){

            @Override
            public void release(int nrPermits) {
            }

            @Override
            public boolean tryAcquire(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException {
                return PermitSupplier.this.tryAcquire(nrPermits, timeout, unit);
            }

            @Override
            public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
                return PermitSupplier.this.tryAcquire(timeout, unit);
            }

            @Override
            public void acquire(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
                PermitSupplier.this.acquire(nrPermits, timeout, unit);
            }

            @Override
            public void acquire(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
                PermitSupplier.this.acquire(timeout, unit);
            }

            @Override
            public boolean tryAcquire(int nrPermits, long deadlineNanos) throws InterruptedException {
                return PermitSupplier.this.tryAcquire(nrPermits, deadlineNanos);
            }
        };
    }

    public static interface Acquisition {
        public static final Acquisition SUCCESS = new Acquisition(){

            @Override
            public boolean isSuccess() {
                return true;
            }

            @Override
            public long permitAvailableEstimateInNanos() {
                return 0L;
            }
        };

        public static Acquisition failed(final long nanosUntilAvailable) {
            return new Acquisition(){

                @Override
                public boolean isSuccess() {
                    return false;
                }

                @Override
                public long permitAvailableEstimateInNanos() {
                    return nanosUntilAvailable;
                }
            };
        }

        public boolean isSuccess();

        public long permitAvailableEstimateInNanos();
    }
}

