/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import org.spf4j.concurrent.Sequence;

public final class ScalableSequence
implements Sequence {
    private final AtomicLong counter;
    private final long bucketSize;
    private final ThreadLocal<Bucket> buckets;

    public ScalableSequence(long start, final int bucketSize) {
        if (bucketSize < 10) {
            throw new IllegalArgumentException("Bucket size must be greater than 10 and not " + bucketSize);
        }
        this.counter = new AtomicLong(start);
        this.bucketSize = bucketSize;
        this.buckets = new ThreadLocal(){

            protected Bucket initialValue() {
                long start = ScalableSequence.this.counter.getAndAdd(bucketSize);
                return new Bucket(start, start + (long)bucketSize);
            }
        };
    }

    @Override
    public long next() {
        Bucket bucket = this.buckets.get();
        if (bucket.hasValue()) {
            return bucket.getValue();
        }
        long start = this.counter.getAndAdd(this.bucketSize);
        bucket.reset(start + 1L, start + this.bucketSize);
        return start;
    }

    public String toString() {
        return "ScalableSequence{counter=" + this.counter + ", bucketSize=" + this.bucketSize + '}';
    }

    private static final class Bucket {
        private long current;
        private long max;

        Bucket(long start, long end) {
            this.current = start;
            this.max = end;
        }

        public void reset(long start, long end) {
            this.current = start;
            this.max = end;
        }

        public boolean hasValue() {
            return this.current < this.max;
        }

        public long getValue() {
            return this.current++;
        }
    }
}

