/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.io.BaseEncoding;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.AppendableUtils;
import org.spf4j.concurrent.Sequence;
import org.spf4j.os.ProcessUtil;

@ParametersAreNonnullByDefault
public final class UIDGenerator
implements Supplier<CharSequence> {
    private final Sequence sequence;
    private final StringBuilder base;
    private final int maxSize;

    public UIDGenerator(Sequence sequence) {
        this(sequence, 0L);
    }

    public UIDGenerator(Sequence sequence, String prefix) {
        this(sequence, BaseEncoding.base64Url(), 0L, '.', prefix);
    }

    public UIDGenerator(Sequence sequence, long customEpoch) {
        this(sequence, BaseEncoding.base64Url(), customEpoch, '.', "");
    }

    public UIDGenerator(Sequence sequence, String prefix, long customEpoch) {
        this(sequence, BaseEncoding.base64Url(), customEpoch, '.', prefix);
    }

    @SuppressFBWarnings(value={"STT_TOSTRING_STORED_IN_FIELD"})
    public UIDGenerator(Sequence sequence, BaseEncoding baseEncoding, long customEpoch, char separator, String prefix) {
        StringBuilder sb;
        this.sequence = sequence;
        this.base = sb = UIDGenerator.generateIdBase(prefix, baseEncoding, separator, customEpoch);
        this.maxSize = this.base.length() + 16;
    }

    public static StringBuilder generateIdBase(String prefix, char separator) {
        return UIDGenerator.generateIdBase(prefix, BaseEncoding.base64Url(), separator, 1509741164184L);
    }

    public static StringBuilder generateIdBase(String prefix, char separator, long customEpoch) {
        return UIDGenerator.generateIdBase(prefix, BaseEncoding.base64Url(), separator, customEpoch);
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public static StringBuilder generateIdBase(String prefix, BaseEncoding baseEncoding, char separator, long customEpoch) {
        byte[] intfMac;
        StringBuilder sb;
        block10: {
            sb = new StringBuilder(16 + prefix.length());
            sb.append(prefix);
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                if (networkInterfaces != null && networkInterfaces.hasMoreElements()) {
                    while (((intfMac = networkInterfaces.nextElement().getHardwareAddress()) == null || intfMac.length == 0) && networkInterfaces.hasMoreElements()) {
                    }
                    if (intfMac != null) break block10;
                    Logger.getLogger(UIDGenerator.class.getName()).warning("Unable to get interface MAC address for ID generation");
                    try {
                        intfMac = ByteBuffer.allocate(8).putLong(SecureRandom.getInstanceStrong().nextLong()).array();
                        break block10;
                    }
                    catch (NoSuchAlgorithmException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                Logger.getLogger(UIDGenerator.class.getName()).warning("Unable to get interface MAC address for ID generation");
                try {
                    intfMac = ByteBuffer.allocate(8).putLong(SecureRandom.getInstanceStrong().nextLong()).array();
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            catch (SocketException ex) {
                Logger.getLogger(UIDGenerator.class.getName()).log(Level.WARNING, "Unable to get interface MAC address for ID generation", ex);
                try {
                    intfMac = ByteBuffer.allocate(8).putLong(SecureRandom.getInstanceStrong().nextLong()).array();
                }
                catch (NoSuchAlgorithmException ex2) {
                    ex2.addSuppressed(ex);
                    throw new IllegalStateException(ex2);
                }
            }
        }
        sb.append(baseEncoding.encode(intfMac)).append(separator);
        AppendableUtils.appendUnsignedString(sb, ProcessUtil.getPid(), 5);
        sb.append(separator);
        AppendableUtils.appendUnsignedString(sb, (System.currentTimeMillis() - customEpoch) / 1000L, 5);
        sb.append(separator);
        return sb;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public CharSequence next() {
        StringBuilder result = new StringBuilder(this.maxSize);
        result.append((CharSequence)this.base);
        AppendableUtils.appendUnsignedString(result, this.sequence.next(), 5);
        return result;
    }

    public String toString() {
        return "UIDGenerator{sequence=" + this.sequence + ", base=" + this.base + ", maxSize=" + this.maxSize + '}';
    }

    @Override
    public CharSequence get() {
        return this.next();
    }
}

