/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Callables;
import org.spf4j.base.MemorizedCallable;
import org.spf4j.base.UncheckedExecutionException;

@ParametersAreNonnullByDefault
public final class UnboundedLoadingCache<K, V>
implements LoadingCache<K, V> {
    private final ConcurrentMap<K, Callable<? extends V>> map;
    private final CacheLoader<K, V> loader;

    public UnboundedLoadingCache(int initialSize, CacheLoader<K, V> loader) {
        this(initialSize, 8, loader);
    }

    public UnboundedLoadingCache(int initialSize, int concurrency, CacheLoader<K, V> loader) {
        this.map = new ConcurrentHashMap<K, Callable<? extends V>>(initialSize, 0.75f, concurrency);
        this.loader = loader;
    }

    public UnboundedLoadingCache(Comparator<? super K> comparator, CacheLoader<K, V> loader) {
        this.map = new ConcurrentSkipListMap<K, Callable<? extends V>>(comparator);
        this.loader = loader;
    }

    public V get(K key) throws ExecutionException {
        MemorizedCallable<Object> newHolder;
        MemorizedCallable<Object> existingValHolder = (MemorizedCallable<Object>)this.map.get(key);
        if (existingValHolder == null && (existingValHolder = (Callable)this.map.putIfAbsent(key, newHolder = Callables.memorized(() -> this.loader.load(key)))) == null) {
            existingValHolder = newHolder;
        }
        try {
            return existingValHolder.call();
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException ex) {
            throw new UncheckedExecutionException(ex);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (K key : keys) {
            builder.put(key, this.get(key));
        }
        return builder.build();
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public V apply(K key) {
        return this.getUnchecked(key);
    }

    public void refresh(final K key) {
        MemorizedCallable newHolder = Callables.memorized(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return UnboundedLoadingCache.this.loader.load(key);
            }
        });
        this.map.put(key, newHolder);
    }

    public ConcurrentMap<K, V> asMap() {
        return new MapView();
    }

    @Nullable
    public V getIfPresent(Object key) {
        Callable existingValHolder = (Callable)this.map.get(key);
        if (existingValHolder != null) {
            try {
                return existingValHolder.call();
            }
            catch (Exception ex) {
                throw new UncheckedExecutionException(ex);
            }
        }
        return null;
    }

    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        MemorizedCallable<V> newHolder;
        MemorizedCallable<V> existingValHolder = (MemorizedCallable<V>)this.map.get(key);
        if (existingValHolder == null && (existingValHolder = (Callable)this.map.putIfAbsent(key, newHolder = Callables.memorized(valueLoader))) == null) {
            existingValHolder = newHolder;
        }
        try {
            return existingValHolder.call();
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object key : keys) {
            V val = this.getIfPresent(key);
            if (val == null) continue;
            builder.put(key, val);
        }
        return builder.build();
    }

    public void put(K key, V value) {
        this.map.put(key, Callables.constant(value));
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void invalidate(Object key) {
        this.map.remove(key);
    }

    public void invalidateAll(Iterable<?> keys) {
        for (Object key : keys) {
            this.invalidate(key);
        }
    }

    public void invalidateAll() {
        this.map.clear();
    }

    public long size() {
        return this.map.size();
    }

    public CacheStats stats() {
        throw new UnsupportedOperationException("Not supported");
    }

    @SuppressFBWarnings(value={"NM_CONFUSING"})
    public void cleanUp() {
        this.map.clear();
    }

    public Set<K> getKeysLoaded() {
        return this.map.keySet();
    }

    public String toString() {
        return "UnboundedLoadingCache{map=" + this.map + ", loader=" + this.loader + '}';
    }

    private class MapView
    implements ConcurrentMap<K, V> {
        private MapView() {
        }

        @Override
        public V putIfAbsent(K key, V value) {
            Callable result = UnboundedLoadingCache.this.map.putIfAbsent(key, Callables.constant(value));
            try {
                return result == null ? null : (Object)result.call();
            }
            catch (Exception ex) {
                throw new UncheckedExecutionException(ex);
            }
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return UnboundedLoadingCache.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return UnboundedLoadingCache.this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return UnboundedLoadingCache.this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(Object key) {
            Callable result = (Callable)UnboundedLoadingCache.this.map.get(key);
            try {
                return result == null ? null : (Object)result.call();
            }
            catch (Exception ex) {
                throw new UncheckedExecutionException(ex);
            }
        }

        @Override
        public V put(K key, V value) {
            Callable result = UnboundedLoadingCache.this.map.put(key, Callables.constant(value));
            try {
                return result == null ? null : (Object)result.call();
            }
            catch (Exception ex) {
                throw new UncheckedExecutionException(ex);
            }
        }

        @Override
        public V remove(Object key) {
            Callable result = (Callable)UnboundedLoadingCache.this.map.remove(key);
            try {
                return result == null ? null : (Object)result.call();
            }
            catch (Exception ex) {
                throw new UncheckedExecutionException(ex);
            }
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry entry : m.entrySet()) {
                UnboundedLoadingCache.this.map.put(entry.getKey(), entry::getValue);
            }
        }

        @Override
        public void clear() {
            UnboundedLoadingCache.this.map.clear();
        }

        @Override
        public Set<K> keySet() {
            return UnboundedLoadingCache.this.map.keySet();
        }

        @Override
        public Collection<V> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

