/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Closeables;
import org.spf4j.base.Iterables;
import org.spf4j.base.Runtime;
import org.spf4j.base.TimeSource;
import org.spf4j.base.Timing;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.concurrent.jdbc.HeartBeatError;
import org.spf4j.concurrent.jdbc.HeartBeatTableDesc;
import org.spf4j.jdbc.JdbcTemplate;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "PMB_POSSIBLE_MEMORY_BLOAT", "SQL_INJECTION_JDBC"}, justification="The db object names are configurable,we for know allow heartbeats to multiple data sources, should be one mostly")
@ThreadSafe
public final class JdbcHeartBeat
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcHeartBeat.class);
    private static final Map<DataSource, JdbcHeartBeat> HEARTBEATS = new IdentityHashMap<DataSource, JdbcHeartBeat>();
    private static final int HEARTBEAT_INTERVAL_MILLIS = Integer.getInteger("spf4j.jdbc.heartBeats.defaultIntervalMillis", 10000);
    @GuardedBy(value="HEARTBEATS")
    private static boolean isShuttingdown = false;
    private final List<LifecycleHook> lifecycleHooks;
    private final JdbcTemplate jdbc;
    private final String insertHeartbeatSql;
    private final String updateHeartbeatSql;
    private final String selectLastRunSql;
    private final int jdbcTimeoutSeconds;
    private final long intervalNanos;
    private final long intervalMillis;
    private final HeartBeatTableDesc hbTableDesc;
    private final String deleteSql;
    private final String deleteHeartBeatSql;
    private volatile long lastRunNanos;
    private boolean isClosed;
    private ListenableScheduledFuture<?> scheduledHearbeat;
    private final long beatDurationNanos;
    private ScheduledHeartBeat heartbeatRunnable;
    private final double missedHBRatio;
    private final long maxMissedNanos;
    private final long tryBeatThresholdNanos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public void close() throws SQLException {
        boolean weClosed = false;
        JdbcTemplate jdbcTemplate = this.jdbc;
        synchronized (jdbcTemplate) {
            if (!this.isClosed) {
                weClosed = true;
                this.isClosed = true;
            }
        }
        if (weClosed) {
            this.unregisterJmx();
            ListenableScheduledFuture<?> running = this.scheduledHearbeat;
            if (running != null) {
                this.scheduledHearbeat.cancel(true);
            }
            this.removeHeartBeatRow(this.jdbcTimeoutSeconds);
            for (LifecycleHook hook : this.lifecycleHooks) {
                hook.onClose();
            }
        }
    }

    private JdbcHeartBeat(DataSource dataSource, HeartBeatTableDesc hbTableDesc, long intervalMillis, int jdbcTimeoutSeconds, double missedHBRatio) throws InterruptedException, SQLException {
        long currTime;
        if (intervalMillis < 1000L) {
            throw new IllegalArgumentException("The heartbeat interval should be at least 1s and not " + intervalMillis + " ms");
        }
        this.missedHBRatio = missedHBRatio;
        this.jdbc = new JdbcTemplate(dataSource);
        this.jdbcTimeoutSeconds = jdbcTimeoutSeconds;
        this.intervalMillis = intervalMillis;
        this.intervalNanos = TimeUnit.MILLISECONDS.toNanos(intervalMillis);
        this.tryBeatThresholdNanos = this.intervalNanos / 2L;
        this.maxMissedNanos = (long)((double)this.intervalNanos * (1.0 + missedHBRatio));
        this.hbTableDesc = hbTableDesc;
        this.isClosed = false;
        String hbTableName = hbTableDesc.getTableName();
        String lastHeartbeatColumn = hbTableDesc.getLastHeartbeatColumn();
        String currentTimeMillisFunc = hbTableDesc.getDbType().getCurrTSSqlFn();
        String intervalColumn = hbTableDesc.getIntervalColumn();
        String ownerColumn = hbTableDesc.getOwnerColumn();
        this.insertHeartbeatSql = "insert into " + hbTableName + " (" + ownerColumn + ',' + intervalColumn + ',' + lastHeartbeatColumn + ") VALUES (?, ?, " + currentTimeMillisFunc + ")";
        this.updateHeartbeatSql = "UPDATE " + hbTableName + " SET " + lastHeartbeatColumn + " = " + currentTimeMillisFunc + " WHERE " + ownerColumn + " = ? AND " + lastHeartbeatColumn + " + " + intervalColumn + " * 2 > " + currentTimeMillisFunc;
        this.deleteHeartBeatSql = "DELETE FROM " + hbTableName + " WHERE " + ownerColumn + " = ?";
        this.deleteSql = "DELETE FROM " + hbTableName + " WHERE " + lastHeartbeatColumn + " + " + intervalColumn + " * 2 < " + currentTimeMillisFunc;
        this.selectLastRunSql = "select " + lastHeartbeatColumn + " FROM " + hbTableName + " where " + ownerColumn + " = ?";
        this.lifecycleHooks = new CopyOnWriteArrayList<LifecycleHook>();
        long startTimeNanos = TimeSource.nanoTime();
        this.createHeartbeatRow();
        this.lastRunNanos = currTime = TimeSource.nanoTime();
        long duration = currTime - startTimeNanos;
        this.beatDurationNanos = Math.max(duration, TimeUnit.MILLISECONDS.toNanos(10L));
    }

    public long getBeatDurationNanos() {
        return this.beatDurationNanos;
    }

    public void registerJmx() {
        Registry.export(this);
    }

    public void unregisterJmx() {
        Registry.unregister(this);
    }

    public void addLyfecycleHook(LifecycleHook hook) {
        this.lifecycleHooks.add(hook);
    }

    public void removeLifecycleHook(LifecycleHook hook) {
        this.lifecycleHooks.remove(hook);
    }

    private void createHeartbeatRow() throws InterruptedException, SQLException {
        this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            try (PreparedStatement insert = conn.prepareStatement(this.insertHeartbeatSql);){
                insert.setNString(1, Runtime.PROCESS_ID);
                insert.setLong(2, this.intervalMillis);
                insert.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
                insert.executeUpdate();
            }
            return null;
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
        LOG.debug("Start Heart Beat for {}", (Object)Runtime.PROCESS_ID);
    }

    @JmxExport(description="Remove all dead hearbeat rows")
    public int removeDeadHeartBeatRows(@JmxExport(value="timeoutSeconds") long timeoutSeconds) throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> this.removeDeadHeartBeatRows((Connection)conn, deadlineNanos), timeoutSeconds, TimeUnit.SECONDS);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    int removeDeadHeartBeatRows(Connection conn, long deadlineNanos) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(this.deleteSql);){
            stmt.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
            int n = stmt.executeUpdate();
            return n;
        }
    }

    private void removeHeartBeatRow(int timeoutSeconds) throws SQLException {
        this.jdbc.transactOnConnectionNonInterrupt((conn, deadlineNanos) -> {
            try (PreparedStatement stmt = conn.prepareStatement(this.deleteHeartBeatSql);){
                stmt.setNString(1, Runtime.PROCESS_ID);
                stmt.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
                int nrDeleted = stmt.executeUpdate();
                if (nrDeleted != 1) {
                    throw new IllegalStateException("Heartbeat rows deleted: " + nrDeleted + " for " + Runtime.PROCESS_ID);
                }
            }
            return null;
        }, timeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(value="removeDeadHeartBeatRowsAsync", description="Remove all dead hearbeat rows async")
    public void removeDeadHeartBeatRowsAsyncNoReturn(final @JmxExport(value="timeoutSeconds") long timeoutSeconds) {
        DefaultExecutor.INSTANCE.execute(new AbstractRunnable(true){

            @Override
            public void doRun() throws SQLException, InterruptedException {
                JdbcHeartBeat.this.removeDeadHeartBeatRows(timeoutSeconds);
            }
        });
    }

    public Future<Integer> removeDeadHeartBeatRowsAsync(long timeoutSeconds) {
        return DefaultExecutor.INSTANCE.submit(() -> this.removeDeadHeartBeatRows(timeoutSeconds));
    }

    private ScheduledHeartBeat getHeartBeatRunnable() {
        if (this.heartbeatRunnable == null) {
            this.heartbeatRunnable = new ScheduledHeartBeat();
        }
        return this.heartbeatRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleHeartbeat(final ListeningScheduledExecutorService scheduler) {
        JdbcTemplate jdbcTemplate = this.jdbc;
        synchronized (jdbcTemplate) {
            if (this.isClosed) {
                throw new IllegalStateException("Heartbeater is closed " + this);
            }
            if (this.scheduledHearbeat == null) {
                ListenableScheduledFuture scheduleFut;
                long lrn = this.lastRunNanos;
                long nanosSincelLastHB = TimeSource.nanoTime() - lrn;
                long delayNanos = this.intervalNanos - nanosSincelLastHB;
                if ((double)delayNanos < (double)(-this.intervalNanos) * this.missedHBRatio) {
                    throw new HeartBeatError("Missed heartbeat, last one was " + nanosSincelLastHB + " ns ago");
                }
                if (delayNanos < 0L) {
                    delayNanos = 0L;
                }
                this.scheduledHearbeat = scheduleFut = scheduler.schedule((Runnable)this.getHeartBeatRunnable(), delayNanos, TimeUnit.NANOSECONDS);
                Futures.addCallback((ListenableFuture)scheduleFut, (FutureCallback)new FutureCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(Object result) {
                        JdbcTemplate jdbcTemplate = JdbcHeartBeat.this.jdbc;
                        synchronized (jdbcTemplate) {
                            if (!JdbcHeartBeat.this.isClosed) {
                                JdbcHeartBeat.this.scheduledHearbeat = null;
                                JdbcHeartBeat.this.scheduleHeartbeat(scheduler);
                            }
                        }
                    }

                    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
                    public void onFailure(Throwable t) {
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (!(t instanceof CancellationException)) {
                            throw new HeartBeatError(t);
                        }
                    }
                }, (Executor)DefaultExecutor.INSTANCE);
            }
        }
    }

    @JmxExport
    public void beat() throws SQLException, InterruptedException {
        this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            this.beat((Connection)conn, deadlineNanos);
            return null;
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
        this.lastRunNanos = TimeSource.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beat(Connection conn, long deadlineNanos) {
        JdbcTemplate jdbcTemplate = this.jdbc;
        synchronized (jdbcTemplate) {
            if (this.isClosed) {
                throw new HeartBeatError("Heartbeater is closed " + this);
            }
        }
        try (PreparedStatement stmt = conn.prepareStatement(this.updateHeartbeatSql);){
            stmt.setQueryTimeout(JdbcTemplate.getTimeoutToDeadlineSeconds(deadlineNanos));
            stmt.setNString(1, Runtime.PROCESS_ID);
            int rowsUpdated = stmt.executeUpdate();
            if (rowsUpdated != 1) {
                throw new IllegalStateException("Broken Heartbeat for " + Runtime.PROCESS_ID + "sql : " + this.updateHeartbeatSql + " rows : " + rowsUpdated);
            }
            LOG.debug("Heart Beat for {}", (Object)Runtime.PROCESS_ID);
        }
        catch (SQLException ex) {
            throw new HeartBeatError(ex);
        }
    }

    boolean tryBeat(Connection conn, long currentTimeNanos, long deadlineNanos) {
        if (currentTimeNanos - this.lastRunNanos > this.tryBeatThresholdNanos) {
            this.beat(conn, deadlineNanos);
            return true;
        }
        return false;
    }

    void updateLastRunNanos(long lastRunTime) {
        this.lastRunNanos = lastRunTime;
    }

    @JmxExport(description="The last run time recorded in the DB by this process")
    public long getLastRunDB() throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="The heartbeat interval in miliseconds")
    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    @JmxExport(description="The TimeSource nanos time  the jdbc heartbeat run last")
    public long getLastRunNanos() {
        return this.lastRunNanos;
    }

    @JmxExport
    public String getLastRunTimeStampString() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(Timing.getCurrentTiming().fromNanoTimeToEpochMillis(this.lastRunNanos)), ZoneId.systemDefault()).toString();
    }

    public static JdbcHeartBeat getHeartBeatAndSubscribe(DataSource dataSource, HeartBeatTableDesc hbTableDesc, @Nullable LifecycleHook hook) throws InterruptedException, SQLException {
        return JdbcHeartBeat.getHeartBeatAndSubscribe(dataSource, hbTableDesc, hook, HEARTBEAT_INTERVAL_MILLIS, HEARTBEAT_INTERVAL_MILLIS / 1000);
    }

    public static JdbcHeartBeat getHeartBeatAndSubscribe(DataSource dataSource, HeartBeatTableDesc hbTableDesc, @Nullable LifecycleHook hook, int heartBeatIntevalMillis, int jdbcTimeoutSeconds) throws InterruptedException, SQLException {
        return JdbcHeartBeat.getHeartBeatAndSubscribe(dataSource, hbTableDesc, hook, heartBeatIntevalMillis, jdbcTimeoutSeconds, DefaultScheduler.listenableInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcHeartBeat getHeartBeatAndSubscribe(final DataSource dataSource, HeartBeatTableDesc hbTableDesc, @Nullable LifecycleHook hook, int heartBeatIntevalMillis, int jdbcTimeoutSeconds, ListeningScheduledExecutorService scheduler) throws InterruptedException, SQLException {
        JdbcHeartBeat beat;
        Map<DataSource, JdbcHeartBeat> map = HEARTBEATS;
        synchronized (map) {
            if (isShuttingdown) {
                throw new IllegalStateException("Process is shutting down, no heartbeats are accepted for " + dataSource);
            }
            beat = HEARTBEATS.get(dataSource);
            if (beat == null) {
                beat = new JdbcHeartBeat(dataSource, hbTableDesc, heartBeatIntevalMillis, jdbcTimeoutSeconds, 0.5);
                beat.registerJmx();
                beat.addLyfecycleHook(new LifecycleHook(){

                    @Override
                    public void onError(Error error) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onClose() {
                        Map map = HEARTBEATS;
                        synchronized (map) {
                            HEARTBEATS.remove(dataSource);
                        }
                    }
                });
                final JdbcHeartBeat fbeat = beat;
                Runtime.queueHookAtBeginning(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = HEARTBEATS;
                        synchronized (map) {
                            isShuttingdown = true;
                        }
                        try {
                            fbeat.close();
                        }
                        catch (SQLException | HeartBeatError ex) {
                            Runtime.error("WARN: Could not clean heartbeat record, this error can be ignored since it is a best effort attempt, detail:", ex);
                        }
                    }
                });
                HEARTBEATS.put(dataSource, beat);
            }
        }
        if (hook != null) {
            beat.addLyfecycleHook(hook);
        }
        beat.scheduleHeartbeat(scheduler);
        return beat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopHeartBeats() {
        Map<DataSource, JdbcHeartBeat> map = HEARTBEATS;
        synchronized (map) {
            Exception e = Closeables.closeAll(HEARTBEATS.values());
            if (e != null) {
                throw new RuntimeException(e);
            }
            HEARTBEATS.clear();
        }
    }

    public HeartBeatTableDesc getHbTableDesc() {
        return this.hbTableDesc;
    }

    public String toString() {
        return "JdbcHeartBeat{jdbc=" + this.jdbc + ", jdbcTimeoutSeconds=" + this.jdbcTimeoutSeconds + ", intervalMillis=" + this.intervalMillis + ", hbTableDesc=" + this.hbTableDesc + ", lastRunNanos=" + this.lastRunNanos + '}';
    }

    private class ScheduledHeartBeat
    implements Runnable {
        private ScheduledHeartBeat() {
        }

        @Override
        public void run() {
            long lrn = JdbcHeartBeat.this.lastRunNanos;
            long currentTimeNanos = TimeSource.nanoTime();
            long nanosSinceLastBeat = currentTimeNanos - lrn;
            if (JdbcHeartBeat.this.maxMissedNanos < nanosSinceLastBeat) {
                HeartBeatError err = new HeartBeatError("System too busy to provide regular heartbeat, last heartbeat " + nanosSinceLastBeat + " ns ago");
                this.handleError(err);
            }
            if (nanosSinceLastBeat > JdbcHeartBeat.this.tryBeatThresholdNanos) {
                try {
                    JdbcHeartBeat.this.beat();
                }
                catch (InterruptedException | RuntimeException | SQLException ex) {
                    HeartBeatError err = new HeartBeatError("System failed heartbeat", ex);
                    this.handleError(err);
                }
            }
        }

        public void handleError(HeartBeatError err) {
            for (LifecycleHook hook : JdbcHeartBeat.this.lifecycleHooks) {
                hook.onError(err);
            }
            RuntimeException ex = Iterables.forAll(JdbcHeartBeat.this.lifecycleHooks, t -> {
                try {
                    t.onClose();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
            if (ex != null) {
                err.addSuppressed(ex);
            }
            JdbcHeartBeat.this.lifecycleHooks.clear();
            throw err;
        }
    }

    public static interface LifecycleHook {
        public void onError(Error var1);

        public void onClose() throws SQLException;
    }
}

