/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.ds.SimpleStackNullSupport;

@ParametersAreNonnullByDefault
public final class SimpleStack<T>
extends SimpleStackNullSupport<T> {
    public SimpleStack(int size) {
        super(size);
    }

    public SimpleStack() {
    }

    @Override
    @Nullable
    public T peek() {
        if (this.top > 0) {
            return (T)this.elems[this.top - 1];
        }
        return null;
    }

    @Nullable
    public T peekAndPush(T o) {
        int t = this.top + 1;
        this.ensureCapacity(t);
        this.elems[this.top] = o;
        Object result = this.top >= 0 ? this.elems[this.top - 1] : null;
        this.top = t;
        return (T)result;
    }

    @Nullable
    public T pollLast() {
        if (this.size() <= 0) {
            return null;
        }
        return this.pop();
    }

    @Override
    public boolean remove(Object o) {
        int l = this.top;
        for (int i = 0; i < l; ++i) {
            if (!o.equals(this.elems[i])) continue;
            this.fastRemove(i);
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object o) {
        int l = this.top;
        for (int i = 0; i < l; ++i) {
            if (!o.equals(this.elems[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!o.equals(this.elems[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.top; ++i) {
            if (!this.elems[i].equals(o)) continue;
            return true;
        }
        return false;
    }
}

