/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public class SimpleStackNullSupport<T>
implements List<T> {
    private static final int DEFAULT_SIZE = 32;
    T[] elems;
    int top;

    public SimpleStackNullSupport(int size) {
        this.elems = new Object[size];
        this.top = 0;
    }

    public SimpleStackNullSupport() {
        this(32);
    }

    @Override
    public final boolean isEmpty() {
        return this.top == 0;
    }

    public final void push(T o) {
        int t = this.top + 1;
        this.ensureCapacity(t);
        this.elems[this.top] = o;
        this.top = t;
    }

    public final void pushNull() {
        int t = this.top + 1;
        this.ensureCapacity(t);
        this.top = t;
    }

    public final int pushAndGetIdx(T o) {
        int t = this.top++;
        this.ensureCapacity(this.top);
        this.elems[t] = o;
        return t;
    }

    final void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elems.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elems = Arrays.copyOf(this.elems, newCapacity);
        }
    }

    public final void pushAll(T ... args) {
        if (args.length == 0) {
            return;
        }
        int newTop = this.top + args.length;
        this.ensureCapacity(newTop);
        System.arraycopy(args, 0, this.elems, this.top, args.length);
        this.top = newTop;
    }

    public final T pop() {
        T o = this.elems[--this.top];
        this.elems[this.top] = null;
        return o;
    }

    public final void remove() {
        this.elems[--this.top] = null;
    }

    public final T[] pop(int n) {
        int ot = this.top;
        this.top -= n;
        Object[] result = new Object[n];
        int i = this.top;
        int j = 0;
        while (i < ot) {
            result[j] = this.elems[i];
            this.elems[i] = null;
            ++i;
            ++j;
        }
        return result;
    }

    public final void popTo(T[] to, int n) {
        int ot = this.top;
        this.top -= n;
        int i = this.top;
        int j = 0;
        while (i < ot) {
            to[j] = this.elems[i];
            this.elems[i] = null;
            ++i;
            ++j;
        }
    }

    public final void removeFromTop(int n) {
        int ot = this.top;
        this.top -= n;
        for (int i = this.top; i < ot; ++i) {
            this.elems[i] = null;
        }
    }

    public final T[] popUntil(T until) {
        int i = this.top - 1;
        while (this.elems[i] != until) {
            --i;
        }
        T[] result = Arrays.copyOfRange(this.elems, i + 1, this.top);
        Arrays.fill(this.elems, i, this.top, null);
        this.top = i;
        return result;
    }

    public final boolean hasElements() {
        return this.top > 0;
    }

    public T peek() {
        return this.elems[this.top - 1];
    }

    public final T peekFromTop(int n) {
        return this.elems[this.top - 1 - n];
    }

    public final void replaceFromTop(int n, T value) {
        this.elems[this.top - 1 - n] = value;
    }

    public final T[] peek(int n) {
        return Arrays.copyOfRange(this.elems, this.top - n, this.top);
    }

    public final T[] peekUntil(T until) {
        int i = this.top - 1;
        while (this.elems[i] != until) {
            --i;
        }
        return Arrays.copyOfRange(this.elems, i + 1, this.top);
    }

    public final T peekElemAfter(T until) {
        int i = this.top - 1;
        while (this.elems[i] != until) {
            --i;
        }
        return this.elems[i - 1];
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.top; ++i) {
            this.elems[i] = null;
        }
        this.top = 0;
    }

    public final int getPtr() {
        return this.top;
    }

    public final T getFromPtr(int ptr) {
        if (ptr < 0 || ptr >= this.top) {
            throw new IndexOutOfBoundsException("Trying to get from invalid index: " + ptr + " from: " + this);
        }
        return this.elems[ptr];
    }

    public final String toString(char separator) {
        if (this.top == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(32);
        result.append(this.elems[0]);
        for (int i = 1; i < this.top; ++i) {
            result.append(separator);
            result.append(this.elems[i]);
        }
        return result.toString();
    }

    public String toString() {
        return this.toString('.');
    }

    @Override
    public final int size() {
        return this.top;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.top; ++i) {
            if (!Objects.equals(this.elems[i], o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object[] toArray() {
        return Arrays.copyOf(this.elems, this.top);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean add(T e) {
        this.push(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            for (int i = 0; i < this.top; ++i) {
                if (this.elems[i] != null) continue;
                this.fastRemove(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.top; ++i) {
                if (!o.equals(this.elems[i])) continue;
                this.fastRemove(i);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleStackNullSupport other = (SimpleStackNullSupport)obj;
        if (this.top != other.top) {
            return false;
        }
        return org.spf4j.base.Arrays.deepEquals(this.elems, other.elems, 0, this.top);
    }

    @Override
    public int hashCode() {
        int hashCode = 7;
        for (int i = 0; i < this.top; ++i) {
            T obj = this.elems[i];
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final T get(int index) {
        return this.elems[index];
    }

    @Override
    public final T set(int index, T element) {
        this.ensureCapacity(index);
        T result = this.elems[index];
        this.elems[index] = element;
        return result;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final T remove(int index) {
        if (index >= this.top && index < 0) {
            throw new IndexOutOfBoundsException("Invalid index " + index + ", current size " + this.top);
        }
        T result = this.elems[index];
        int next = index + 1;
        int numMoved = this.top - next;
        if (numMoved > 0) {
            System.arraycopy(this.elems, next, this.elems, index, numMoved);
        }
        this.elems[--this.top] = null;
        return result;
    }

    final void fastRemove(int index) {
        int next = index + 1;
        int numMoved = this.top - next;
        if (numMoved > 0) {
            System.arraycopy(this.elems, next, this.elems, index, numMoved);
        }
        this.elems[--this.top] = null;
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

