/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.InterruptibleCompletableFuture;
import org.spf4j.failsafe.DefaultAsyncExecutor;
import org.spf4j.failsafe.SyncRetryExecutor;

@ThreadSafe
public interface AsyncRetryExecutor<T, C extends Callable<? extends T>>
extends SyncRetryExecutor<T, C> {
    @CheckReturnValue
    default public <R extends T, W extends C> Future<R> submit(W pwhat) {
        long nanoTime = TimeSource.nanoTime();
        return this.submit(pwhat, nanoTime, ExecutionContexts.getContextDeadlineNanos(nanoTime));
    }

    @CheckReturnValue
    default public <R extends T, W extends C> Future<R> submit(W pwhat, long deadlineNanos) {
        return this.submit(pwhat, TimeSource.nanoTime(), deadlineNanos);
    }

    @CheckReturnValue
    default public <R extends T, W extends C> Future<R> submit(W pwhat, long timeout, TimeUnit tu) {
        long nanoTime = TimeSource.nanoTime();
        return this.submit(pwhat, nanoTime, ExecutionContexts.computeDeadline(nanoTime, ExecutionContexts.current(), tu, timeout));
    }

    @CheckReturnValue
    public <R extends T, W extends C> Future<R> submit(W var1, long var2, long var4);

    @CheckReturnValue
    default public <R extends T, W extends C> CompletableFuture<R> submitRx(W pwhat, long timeout, TimeUnit tu) {
        long nanoTime = TimeSource.nanoTime();
        return this.submitRx(pwhat, nanoTime, ExecutionContexts.computeDeadline(nanoTime, ExecutionContexts.current(), tu, timeout));
    }

    @CheckReturnValue
    default public <R extends T, W extends C> CompletableFuture<R> submitRx(W pwhat, long startTimeNanos, long deadlineNanos) {
        return this.submitRx(pwhat, startTimeNanos, deadlineNanos, () -> new InterruptibleCompletableFuture());
    }

    @CheckReturnValue
    public <R extends T, W extends C> CompletableFuture<R> submitRx(W var1, long var2, long var4, Supplier<InterruptibleCompletableFuture<R>> var6);

    default public <W extends C> void execute(W pwhat) {
        long nanoTime = TimeSource.nanoTime();
        this.execute(pwhat, nanoTime, ExecutionContexts.getContextDeadlineNanos(nanoTime));
    }

    public <W extends C> void execute(W var1, long var2, long var4);

    default public <W extends C> void execute(W pwhat, long timeout, TimeUnit tu) {
        long nanoTime = TimeSource.nanoTime();
        this.execute(pwhat, nanoTime, ExecutionContexts.computeDeadline(nanoTime, ExecutionContexts.current(), tu, timeout));
    }

    public static <T, C extends Callable<? extends T>> AsyncRetryExecutor<T, C> defaultAsyncRetryExecutor() {
        return DefaultAsyncExecutor.DEFAULT;
    }

    public static <T, C extends Callable<? extends T>> AsyncRetryExecutor<T, C> noRetryAsyncExecutor() {
        return DefaultAsyncExecutor.NO_RETRY;
    }
}

