/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.spf4j.concurrent.InterruptibleCompletableFuture;
import org.spf4j.failsafe.AsyncRetryExecutor;
import org.spf4j.failsafe.Hedge;
import org.spf4j.failsafe.HedgePolicy;
import org.spf4j.failsafe.RetryPolicy;
import org.spf4j.failsafe.concurrent.FailSafeExecutor;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
final class AsyncRetryExecutorImpl<T, C extends Callable<? extends T>>
implements AsyncRetryExecutor<T, C> {
    private final RetryPolicy<T, C> retryPolicy;
    private final HedgePolicy hedgePolicy;
    private final FailSafeExecutor executor;

    AsyncRetryExecutorImpl(RetryPolicy<T, C> retryPolicy, HedgePolicy hedgePolicy, FailSafeExecutor executor) {
        this.executor = executor;
        this.retryPolicy = retryPolicy;
        this.hedgePolicy = hedgePolicy;
    }

    @Override
    public <R extends T, W extends C> Future<R> submit(W pwhat, long startTimeNanos, long deadlineNanos) {
        Hedge hedge = this.hedgePolicy.getHedge(startTimeNanos, deadlineNanos);
        int hedgeCount = hedge.getHedgeCount();
        if (hedgeCount <= 0) {
            return this.executor.submit(pwhat, this.retryPolicy.getRetryPredicate(startTimeNanos, deadlineNanos));
        }
        return this.executor.submit(pwhat, this.retryPolicy.getRetryPredicate(startTimeNanos, deadlineNanos), hedgeCount, hedge.getHedgeDelayNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public <R extends T, W extends C> CompletableFuture<R> submitRx(W pwhat, long startTimeNanos, long deadlineNanos, Supplier<InterruptibleCompletableFuture<R>> cfSupplier) {
        Hedge hedge = this.hedgePolicy.getHedge(startTimeNanos, deadlineNanos);
        int hedgeCount = hedge.getHedgeCount();
        if (hedgeCount <= 0) {
            return this.executor.submitRx(pwhat, this.retryPolicy.getRetryPredicate(startTimeNanos, deadlineNanos), cfSupplier);
        }
        long hedgeDelayNanos = hedge.getHedgeDelayNanos();
        if (hedgeDelayNanos >= deadlineNanos - startTimeNanos) {
            return this.executor.submitRx(pwhat, this.retryPolicy.getRetryPredicate(startTimeNanos, deadlineNanos), cfSupplier);
        }
        return this.executor.submitRx(pwhat, this.retryPolicy.getRetryPredicate(startTimeNanos, deadlineNanos), hedgeCount, hedgeDelayNanos, TimeUnit.NANOSECONDS, cfSupplier);
    }

    @Override
    public <W extends C> void execute(W pwhat, long startTimeNanos, long deadlineNanos) {
        Hedge hedge = this.hedgePolicy.getHedge(startTimeNanos, deadlineNanos);
        int hedgeCount = hedge.getHedgeCount();
        if (hedgeCount <= 0) {
            this.executor.execute(pwhat, this.retryPolicy.getRetryPredicate(startTimeNanos, deadlineNanos));
        } else {
            this.executor.submit(pwhat, this.retryPolicy.getRetryPredicate(startTimeNanos, deadlineNanos), hedgeCount, hedge.getHedgeDelayNanos(), TimeUnit.NANOSECONDS);
        }
    }

    public String toString() {
        return "AsyncRetryPolicy{executor=" + this.executor + '}';
    }

    @Override
    public <R extends T, W extends C, EX extends Exception> R call(W pwhat, Class<EX> exceptionClass, long startNanos, long deadlineNanos) throws InterruptedException, TimeoutException, EX {
        return this.retryPolicy.call(pwhat, exceptionClass, startNanos, deadlineNanos);
    }
}

