/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.failsafe.RetryDecision;

@ParametersAreNonnullByDefault
@ThreadSafe
final class CountLimitedPartialRetryPredicate<T, V, C extends Callable<? extends T>>
implements BiFunction<V, C, RetryDecision<T, C>> {
    private final BiFunction<V, C, RetryDecision<T, C>> wrapped;
    private int count;

    CountLimitedPartialRetryPredicate(int maxCount, BiFunction<V, C, RetryDecision<T, C>> wrapped) {
        this.wrapped = wrapped;
        this.count = maxCount;
    }

    @Override
    @Nullable
    public synchronized RetryDecision<T, C> apply(V value, C what) {
        RetryDecision<T, C> decision = this.wrapped.apply(value, what);
        if (decision == null) {
            return null;
        }
        if (this.count <= 0) {
            return RetryDecision.abort();
        }
        if (decision.getDecisionType() == RetryDecision.Type.Retry) {
            --this.count;
        }
        return decision;
    }

    public synchronized String toString() {
        return "CountLimitedPartialRetryPredicate{wrapped=" + this.wrapped + ", count=" + this.count + '}';
    }
}

