/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.failsafe.PartialExceptionRetryPredicate;
import org.spf4j.failsafe.PartialResultRetryPredicate;
import org.spf4j.failsafe.RetryDecision;
import org.spf4j.failsafe.RetryDelaySupplier;
import org.spf4j.failsafe.RetryPredicate;
import org.spf4j.failsafe.TimedSupplier;
import org.spf4j.log.Level;
import org.spf4j.log.SLf4jXLogAdapter;
import org.spf4j.log.XLog;

@SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
@ThreadSafe
final class DefaultRetryPredicate<T>
implements RetryPredicate<T, Callable<T>> {
    private static final Level RETRY_LOG_LEVEL = Level.valueOf(System.getProperty("spf4j.failsafe.retryLogLevel", "WARN"));
    private static final PartialResultRetryPredicate[] NO_RP = new PartialResultRetryPredicate[0];
    private static final PartialExceptionRetryPredicate[] NO_EP = new PartialExceptionRetryPredicate[0];
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRetryPredicate.class);
    private final Function<Object, RetryDelaySupplier> defaultBackoffSupplier;
    private final PartialResultRetryPredicate<T, Callable<T>>[] resultPredicates;
    private final PartialExceptionRetryPredicate<T, Callable<T>>[] exceptionPredicates;
    private final XLog log;

    @SuppressFBWarnings(value={"LO_SUSPECT_LOG_PARAMETER"})
    DefaultRetryPredicate(@Nullable Logger log, long startNanos, long deadlineNanos, Supplier<Function<Object, RetryDelaySupplier>> defaultBackoffSupplierSupplier, TimedSupplier<PartialResultRetryPredicate<T, Callable<T>>>[] resultPredicates, TimedSupplier<PartialExceptionRetryPredicate<T, Callable<T>>> ... exceptionPredicates) {
        int epl;
        this.log = new SLf4jXLogAdapter(log == null ? LOG : log);
        this.defaultBackoffSupplier = defaultBackoffSupplierSupplier.get();
        int rpl = resultPredicates.length;
        if (rpl > 0) {
            this.resultPredicates = new PartialResultRetryPredicate[rpl];
            for (int i = 0; i < rpl; ++i) {
                this.resultPredicates[i] = resultPredicates[i].get(startNanos, deadlineNanos);
            }
        } else {
            this.resultPredicates = NO_RP;
        }
        if ((epl = exceptionPredicates.length) > 0) {
            this.exceptionPredicates = new PartialExceptionRetryPredicate[epl];
            for (int i = 0; i < epl; ++i) {
                this.exceptionPredicates[i] = exceptionPredicates[i].get(startNanos, deadlineNanos);
            }
        } else {
            this.exceptionPredicates = NO_EP;
        }
    }

    @Override
    @Nonnull
    public RetryDecision<T, Callable<T>> getDecision(T value, Callable<T> what) {
        for (PartialResultRetryPredicate<T, Callable<T>> predicate : this.resultPredicates) {
            RetryDecision<T, Callable<T>> decision = predicate.getDecision(value, what);
            if (decision == null) continue;
            if (decision.getDecisionType() == RetryDecision.Type.Retry) {
                Callable<T> newCallable = decision.getNewCallable();
                if (decision.getDelayNanos() < 0L) {
                    RetryDelaySupplier backoff = this.defaultBackoffSupplier.apply(value);
                    decision = RetryDecision.retry(backoff.nextDelay(), newCallable);
                }
                this.log.log(null, RETRY_LOG_LEVEL, "Result {}, retrying {} with {}", value, newCallable, decision);
            }
            return decision;
        }
        return RetryDecision.abort();
    }

    @Override
    @Nonnull
    public RetryDecision<T, Callable<T>> getExceptionDecision(Throwable value, Callable<T> what) {
        for (PartialExceptionRetryPredicate<T, Callable<T>> predicate : this.exceptionPredicates) {
            RetryDecision decision = predicate.getExceptionDecision(value, what);
            if (decision == null) continue;
            if (decision.getDecisionType() == RetryDecision.Type.Retry) {
                Callable<T> newCallable = decision.getNewCallable();
                if (decision.getDelayNanos() < 0L) {
                    RetryDelaySupplier backoff = this.defaultBackoffSupplier.apply(value);
                    decision = RetryDecision.retry(backoff.nextDelay(), newCallable);
                }
                this.log.log(null, RETRY_LOG_LEVEL, "Result {}, retrying {} with {}", value.getClass().getName(), newCallable, decision, value);
            }
            return decision;
        }
        return RetryDecision.abort();
    }

    public String toString() {
        return "DefaultRetryPredicate{defaultBackoffSupplier=" + this.defaultBackoffSupplier + ", resultPredicates=" + Arrays.toString(this.resultPredicates) + ", exceptionPredicates=" + Arrays.toString(this.exceptionPredicates) + '}';
    }
}

