/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.failsafe.RetryDelaySupplier;

@ThreadSafe
public final class FibonacciRetryDelaySupplier
implements RetryDelaySupplier {
    private int immediateLeft;
    private long p1;
    private long p2;
    private final long maxDelay;
    private final long startDelay;

    public FibonacciRetryDelaySupplier(int immediateLeft, long startDelay, long maxDelay) {
        this.immediateLeft = immediateLeft;
        this.startDelay = startDelay;
        this.maxDelay = maxDelay;
        if (startDelay < 1L) {
            this.p1 = 0L;
            this.p2 = 1L;
        } else {
            this.p1 = startDelay;
            this.p2 = startDelay + 1L;
        }
    }

    @Override
    public synchronized long nextDelay() {
        if (this.immediateLeft > 0) {
            --this.immediateLeft;
            return this.p1;
        }
        if (this.p2 > this.maxDelay) {
            return this.maxDelay;
        }
        long result = this.p2;
        this.p2 = this.p1 + this.p2;
        this.p1 = result;
        return result;
    }

    public synchronized String toString() {
        return "FibonacciBackoff{immediateLeft=" + this.immediateLeft + ", p1=" + this.p1 + ", p2=" + this.p2 + ", maxDelay=" + this.maxDelay + ", startDelay=" + this.startDelay + '}';
    }
}

