/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.PermitSupplier;

public final class GuavaRateLimiter
implements PermitSupplier {
    private final RateLimiter limiter;

    public GuavaRateLimiter(RateLimiter limiter) {
        this.limiter = limiter;
    }

    @Override
    public boolean tryAcquire(int nrPermits, long deadlineNanos) throws InterruptedException {
        long nanosToDeadline = deadlineNanos - TimeSource.nanoTime();
        if (nanosToDeadline <= 0L) {
            return false;
        }
        return this.tryAcquire(nrPermits, nanosToDeadline, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean tryAcquire(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.limiter.tryAcquire(nrPermits, timeout, unit);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return result;
    }

    public RateLimiter getLimiter() {
        return this.limiter;
    }

    public String toString() {
        return "GuavaRateLimiter{limiter=" + this.limiter + '}';
    }
}

