/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.failsafe.RetryDelaySupplier;

@ThreadSafe
final class JitteredDelaySupplier
implements RetryDelaySupplier {
    private final RetryDelaySupplier wrapped;
    private final double jitterFactor;

    JitteredDelaySupplier(RetryDelaySupplier wrapped, double jitterFactor) {
        this.wrapped = wrapped;
        this.jitterFactor = jitterFactor;
    }

    @Override
    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
    public long nextDelay() {
        long nextDelay = this.wrapped.nextDelay();
        if (nextDelay > 1L) {
            long jitter = (long)((double)nextDelay * this.jitterFactor);
            if (jitter > 0L) {
                return ThreadLocalRandom.current().nextLong(Math.max(0L, nextDelay - jitter), nextDelay);
            }
            return nextDelay;
        }
        return nextDelay;
    }

    public String toString() {
        return "JitteredDelaySupplier{wrapped=" + this.wrapped + '}';
    }
}

