/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import com.google.common.annotations.Beta;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.Callables;
import org.spf4j.base.UncheckedExecutionException;
import org.spf4j.concurrent.PermitSupplier;
import org.spf4j.concurrent.Semaphore;

@Beta
public final class LimitingExecutor<T, C extends Callable<? extends T>>
implements Executor {
    private final RejectedExecutionHandler rejectHandler;
    private final Semaphore semaphore;

    public LimitingExecutor(PermitSupplier permitSupplier) {
        this(permitSupplier.toSemaphore());
    }

    public LimitingExecutor(Semaphore semaphore) {
        this(new RejectedExecutionHandler<T, C>(){

            @Override
            public T reject(LimitingExecutor<T, C> limiter, C callable) {
                throw new RejectedExecutionException("No buckets available for " + callable + " in limiter " + limiter);
            }
        }, semaphore);
    }

    public LimitingExecutor(RejectedExecutionHandler<T, C> rejectHandler, Semaphore semaphore) {
        this.rejectHandler = rejectHandler;
        this.semaphore = semaphore;
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.execute(Callables.from(command));
        }
        catch (Exception ex) {
            throw new UncheckedExecutionException(ex);
        }
    }

    public <T> T execute(C callable) throws Exception {
        if (this.semaphore.tryAcquire(0L, TimeUnit.NANOSECONDS)) {
            try {
                Object v = callable.call();
                return (T)v;
            }
            finally {
                this.semaphore.release();
            }
        }
        return this.rejectHandler.reject(this, callable);
    }

    public Callable<T> toLimitedCallable(C callable) {
        return () -> this.execute(callable);
    }

    public RejectedExecutionHandler getRejectHandler() {
        return this.rejectHandler;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public String toString() {
        return "LimitedExecutor{rejectHandler=" + this.rejectHandler + ", semaphore=" + this.semaphore + '}';
    }

    @FunctionalInterface
    public static interface RejectedExecutionHandler<T, C extends Callable<? extends T>> {
        public T reject(LimitingExecutor<T, C> var1, C var2) throws Exception;
    }
}

