/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Signed;
import javax.annotation.concurrent.GuardedBy;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.Atomics;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.concurrent.PermitSupplier;

@Beta
public final class RateLimiter
implements AutoCloseable,
PermitSupplier {
    private static final int RE_READ_TIME_AFTER_RETRIES = Integer.getInteger("spf4j.rateLimiter.reReadTimeAfterTries", 5);
    private static final long DEFAULT_MIN_REPLENISH_INTERVAL_MS = Long.getLong("spf4j.rateLimiter.defaultMinReplenishIntervalMs", 10L);
    private final AtomicLong permits;
    private final ScheduledFuture<?> replenisher;
    private final long permitsPerReplenishInterval;
    private final long permitReplenishIntervalNanos;
    private final LongSupplier nanoTimeSupplier;
    @GuardedBy(value="sync")
    private long lastReplenishmentNanos;
    private final Object sync;
    private final int maxBackoffNanos;
    private final LongBinaryOperator accumulate;

    public RateLimiter(long permitsPerReplenishInterval, Duration replenishmentInterval, long maxBurstSize, long minReplenishInterval, TimeUnit tu) {
        this(permitsPerReplenishInterval, replenishmentInterval, maxBurstSize, minReplenishInterval, tu, DefaultScheduler.INSTANCE, TimeSource.nanoTimeSupplier());
    }

    public RateLimiter(long permitsPerReplenishInterval, Duration replenishmentInterval, long maxBurstSize) {
        this(permitsPerReplenishInterval, replenishmentInterval, maxBurstSize, DefaultScheduler.INSTANCE);
    }

    public RateLimiter(long permitsPerReplenishInterval, Duration replenishmentInterval, long maxBurstSize, ScheduledExecutorService scheduler) {
        this(permitsPerReplenishInterval, replenishmentInterval, maxBurstSize, scheduler, TimeSource.nanoTimeSupplier());
    }

    public RateLimiter(long permitsPerReplenishInterval, Duration replenishmentInterval, long maxBurstSize, ScheduledExecutorService scheduler, LongSupplier nanoTimeSupplier) {
        this(permitsPerReplenishInterval, replenishmentInterval, maxBurstSize, DEFAULT_MIN_REPLENISH_INTERVAL_MS, TimeUnit.MILLISECONDS, scheduler, nanoTimeSupplier);
    }

    public RateLimiter(long permitsPerReplenishInterval, Duration replenishmentInterval, long maxBurstSize, long minReplenishInterval, TimeUnit tu, ScheduledExecutorService scheduler, LongSupplier nanoTimeSupplier) {
        this(permitsPerReplenishInterval, replenishmentInterval, maxBurstSize, minReplenishInterval, tu, scheduler, nanoTimeSupplier, Atomics.MAX_BACKOFF_NANOS);
    }

    public RateLimiter(long permitsPerReplenishInterval, Duration replenishmentInterval, long maxAvailablePermits, long minReplenishInterval, TimeUnit tu, ScheduledExecutorService scheduler, LongSupplier nanoTimeSupplier, int maxBackoffNanos) {
        this(permitsPerReplenishInterval, replenishmentInterval, 0L, maxAvailablePermits, minReplenishInterval, tu, scheduler, nanoTimeSupplier, maxBackoffNanos);
    }

    public RateLimiter(long permitsPerReplenishInterval, Duration replenishmentInterval, long initialNrOfPermits, long maxAvailablePermits, long minReplenishInterval, TimeUnit tu, ScheduledExecutorService scheduler, LongSupplier nanoTimeSupplier, int maxBackoffNanos) {
        this.maxBackoffNanos = maxBackoffNanos;
        this.sync = new Object();
        this.nanoTimeSupplier = nanoTimeSupplier;
        this.permitReplenishIntervalNanos = replenishmentInterval.toNanos();
        this.permitsPerReplenishInterval = permitsPerReplenishInterval;
        assert (permitsPerReplenishInterval >= 1L);
        if (maxAvailablePermits < permitsPerReplenishInterval) {
            throw new IllegalArgumentException("Invalid max burst size: " + maxAvailablePermits + ",  increase maxBurstSize to something larger than " + permitsPerReplenishInterval + " we assume a clock resolution of " + this.permitReplenishIntervalNanos + " and that is the minimum replenish interval");
        }
        this.permits = new AtomicLong(initialNrOfPermits);
        this.lastReplenishmentNanos = nanoTimeSupplier.getAsLong();
        this.accumulate = (left, right) -> {
            long result = left + right;
            return result > maxAvailablePermits ? maxAvailablePermits : result;
        };
        this.replenisher = scheduler.scheduleAtFixedRate(() -> {
            Object object = this.sync;
            synchronized (object) {
                Atomics.accumulate(this.permits, permitsPerReplenishInterval, this.accumulate, maxBackoffNanos);
                this.lastReplenishmentNanos = nanoTimeSupplier.getAsLong();
            }
        }, this.permitReplenishIntervalNanos, this.permitReplenishIntervalNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean addPermits(int nrPermits) {
        return Atomics.maybeAccumulate(this.permits, nrPermits, this.accumulate, this.maxBackoffNanos);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    public boolean tryAcquire(int nrPermits) {
        return Atomics.maybeAccumulate(this.permits, nrPermits, (prev, x) -> {
            long dif = prev - x;
            return dif < 0L ? prev : dif;
        }, this.maxBackoffNanos);
    }

    public long getNrPermits() {
        return this.permits.get();
    }

    @Override
    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    public boolean tryAcquire(int nrPermits, long deadlineNanos) throws InterruptedException {
        PermitSupplier.Acquisition acq = this.tryAcquireGetDelayNanos(nrPermits, deadlineNanos);
        if (acq.isSuccess()) {
            long permitAvailableEstimateInNanos = acq.permitAvailableEstimateInNanos();
            if (permitAvailableEstimateInNanos > 0L) {
                TimeUnit.NANOSECONDS.sleep(permitAvailableEstimateInNanos);
            }
            return true;
        }
        return false;
    }

    @Override
    @CheckReturnValue
    public boolean tryAcquire(@Nonnegative int nrPermits, @Nonnegative long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("incalid timeout " + timeout + ' ' + (Object)((Object)unit));
        }
        boolean tryAcquire = this.tryAcquire(nrPermits);
        if (tryAcquire) {
            return true;
        }
        if (timeout == 0L) {
            return false;
        }
        ReservationHandler acq = this.forceReserve(ExecutionContexts.computeDeadline(timeout, unit), nrPermits);
        if (acq.isSuccess()) {
            long permitAvailableEstimateInNanos = acq.permitAvailableEstimateInNanos();
            if (permitAvailableEstimateInNanos > 0L) {
                TimeUnit.NANOSECONDS.sleep(permitAvailableEstimateInNanos);
            }
            return true;
        }
        return false;
    }

    @Override
    public PermitSupplier.Acquisition tryAcquireEx(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException {
        long permitAvailableEstimateInNanos;
        boolean tryAcquire = this.tryAcquire(nrPermits);
        if (tryAcquire) {
            return PermitSupplier.Acquisition.SUCCESS;
        }
        ReservationHandler acq = this.forceReserve(ExecutionContexts.computeDeadline(timeout, unit), nrPermits);
        if (acq.isSuccess() && (permitAvailableEstimateInNanos = acq.permitAvailableEstimateInNanos()) > 0L) {
            TimeUnit.NANOSECONDS.sleep(permitAvailableEstimateInNanos);
        }
        return acq;
    }

    @Override
    public PermitSupplier.Acquisition tryAcquireEx(int nrPermits, long deadlineNanos) throws InterruptedException {
        long permitAvailableEstimateInNanos;
        PermitSupplier.Acquisition acq = this.tryAcquireGetDelayNanos(nrPermits, deadlineNanos);
        if (acq.isSuccess() && (permitAvailableEstimateInNanos = acq.permitAvailableEstimateInNanos()) > 0L) {
            TimeUnit.NANOSECONDS.sleep(permitAvailableEstimateInNanos);
        }
        return acq;
    }

    @Signed
    PermitSupplier.Acquisition tryAcquireGetDelayNanos(int nrPermits, long deadlineNanos) {
        boolean tryAcquire = this.tryAcquire(nrPermits);
        if (tryAcquire) {
            return PermitSupplier.Acquisition.SUCCESS;
        }
        return this.forceReserve(deadlineNanos, nrPermits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReservationHandler forceReserve(long deadlineNanos, int nrPermits) {
        if (this.replenisher.isCancelled()) {
            throw new IllegalStateException("RateLimiter is closed: " + this);
        }
        ReservationHandler rh = new ReservationHandler(this.nanoTimeSupplier.getAsLong(), deadlineNanos);
        Object object = this.sync;
        synchronized (object) {
            Atomics.accumulate(this.permits, nrPermits, rh, this.maxBackoffNanos);
        }
        return rh;
    }

    @Override
    public void close() {
        this.replenisher.cancel(false);
    }

    public long getPermitsPerReplenishInterval() {
        return this.permitsPerReplenishInterval;
    }

    public long getPermitReplenishIntervalNanos() {
        return this.permitReplenishIntervalNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastReplenishmentNanos() {
        Object object = this.sync;
        synchronized (object) {
            return this.lastReplenishmentNanos;
        }
    }

    public String toString() {
        return "RateLimiter{permits=" + this.permits.get() + ", permitsPerReplenishInterval=" + this.permitsPerReplenishInterval + ", permitReplenishIntervalNanos=" + this.permitReplenishIntervalNanos + '}';
    }

    private final class ReservationHandler
    implements LongBinaryOperator,
    PermitSupplier.Acquisition {
        private long currTimeNanos;
        private final long deadlineNanos;
        private long nsUntilResourcesAvailable;
        private int reTimeCount;
        private boolean isSuccess;

        ReservationHandler(long currTimeNanos, long deadlineNanos) {
            this.currTimeNanos = currTimeNanos;
            this.deadlineNanos = deadlineNanos;
            this.nsUntilResourcesAvailable = 0L;
            this.reTimeCount = RE_READ_TIME_AFTER_RETRIES;
            this.isSuccess = false;
        }

        @Override
        public long applyAsLong(long prev, long nrPermits) {
            long nsNeeded;
            long remaimingPermits = prev - nrPermits;
            if (remaimingPermits >= 0L) {
                this.isSuccess = true;
                return remaimingPermits;
            }
            if (this.reTimeCount > 0) {
                --this.reTimeCount;
            } else {
                this.reTimeCount = RE_READ_TIME_AFTER_RETRIES;
                this.currTimeNanos = RateLimiter.this.nanoTimeSupplier.getAsLong();
            }
            long timeoutNs = this.deadlineNanos - this.currTimeNanos;
            long nsUntilNextReplenishment = RateLimiter.this.permitReplenishIntervalNanos - (this.currTimeNanos - RateLimiter.this.lastReplenishmentNanos);
            long permitsNeeded = -remaimingPermits;
            if (permitsNeeded <= RateLimiter.this.permitsPerReplenishInterval) {
                this.nsUntilResourcesAvailable = nsUntilNextReplenishment;
                return remaimingPermits;
            }
            int numberOfReplenishMentsNeed = permitsNeeded % RateLimiter.this.permitsPerReplenishInterval == 0L ? (int)(permitsNeeded / RateLimiter.this.permitsPerReplenishInterval) : (int)(permitsNeeded / RateLimiter.this.permitsPerReplenishInterval + 1L);
            this.nsUntilResourcesAvailable = nsNeeded = nsUntilNextReplenishment + (long)(numberOfReplenishMentsNeed - 1) * RateLimiter.this.permitReplenishIntervalNanos;
            if (nsNeeded <= timeoutNs) {
                this.isSuccess = true;
                return remaimingPermits;
            }
            return prev;
        }

        public long getNsUntilResourcesAvailable() {
            return this.nsUntilResourcesAvailable;
        }

        public String toString() {
            return "ReservationHandler{deadlineNanos=" + this.deadlineNanos + ", permits=" + RateLimiter.this.permits + ", nsUntilResourcesAvailable=" + this.nsUntilResourcesAvailable + '}';
        }

        @Override
        public boolean isSuccess() {
            return this.isSuccess;
        }

        @Override
        public long permitAvailableEstimateInNanos() {
            return this.nsUntilResourcesAvailable;
        }
    }
}

