/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spf4j.base.Either;

public interface RetryDecision<T, C extends Callable<? extends T>> {
    public static final RetryDecision<?, ?> ABORT = new RetryDecision(){

        @Override
        public Type getDecisionType() {
            return Type.Abort;
        }

        @Override
        public long getDelayNanos() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Either<Throwable, ?> getResult() {
            return null;
        }

        public Callable getNewCallable() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ABORT";
        }
    };

    @CheckReturnValue
    public static RetryDecision abort() {
        return ABORT;
    }

    @CheckReturnValue
    public static RetryDecision abortThrow(final @Nonnull Throwable exception) {
        return new RetryDecision(){

            @Override
            public Type getDecisionType() {
                return Type.Abort;
            }

            @Override
            public long getDelayNanos() {
                throw new UnsupportedOperationException();
            }

            public Callable<?> getNewCallable() {
                throw new UnsupportedOperationException();
            }

            public Either getResult() {
                return Either.left(exception);
            }

            public String toString() {
                return "ABORT(" + exception.getClass() + ')';
            }
        };
    }

    @CheckReturnValue
    public static <T> RetryDecision<T, ? extends Callable<? extends T>> abortReturn(final T result) {
        return new RetryDecision<T, Callable<T>>(){

            @Override
            public Type getDecisionType() {
                return Type.Abort;
            }

            @Override
            public long getDelayNanos() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Either<Throwable, T> getResult() {
                return Either.right(result);
            }

            @Override
            public Callable<T> getNewCallable() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "ABORT(" + result + ')';
            }
        };
    }

    @CheckReturnValue
    public static <T, C extends Callable<? extends T>> RetryDecision<T, C> retry(@Nonnegative long time, TimeUnit unit, @Nonnull C callable) {
        return RetryDecision.retry(unit.toNanos(time), callable);
    }

    @CheckReturnValue
    public static <T, C extends Callable<? extends T>> RetryDecision<T, C> retry(final @Nonnegative long retryNanos, final @Nonnull C callable) {
        return new RetryDecision<T, C>(){

            @Override
            public Type getDecisionType() {
                return Type.Retry;
            }

            @Override
            public long getDelayNanos() {
                return retryNanos;
            }

            @Override
            public Either<Throwable, T> getResult() {
                throw new UnsupportedOperationException();
            }

            @Override
            public C getNewCallable() {
                return callable;
            }

            public String toString() {
                return "RETRY(" + retryNanos + "ns, " + callable + ')';
            }
        };
    }

    @CheckReturnValue
    public static <T, C extends Callable<? extends T>> RetryDecision<T, C> retryDefault(final @Nonnull C callable) {
        return new RetryDecision<T, C>(){

            @Override
            public Type getDecisionType() {
                return Type.Retry;
            }

            @Override
            public long getDelayNanos() {
                return -1L;
            }

            @Override
            public Either<Throwable, T> getResult() {
                throw new UnsupportedOperationException();
            }

            @Override
            public C getNewCallable() {
                return callable;
            }

            public String toString() {
                return "RETRY(" + callable + ')';
            }
        };
    }

    @CheckReturnValue
    @Nonnull
    public Type getDecisionType();

    @CheckReturnValue
    public long getDelayNanos();

    @CheckReturnValue
    @Nullable
    public Either<Throwable, T> getResult();

    @CheckReturnValue
    @Nonnull
    public C getNewCallable();

    public static enum Type {
        Abort,
        Retry;

    }
}

