/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;
import org.spf4j.base.Throwables;
import org.spf4j.failsafe.AsyncRetryExecutor;
import org.spf4j.failsafe.AsyncRetryExecutorImpl;
import org.spf4j.failsafe.CountLimitedPartialRetryPredicate;
import org.spf4j.failsafe.DefaultRetryPredicate;
import org.spf4j.failsafe.FibonacciRetryDelaySupplier;
import org.spf4j.failsafe.HedgePolicy;
import org.spf4j.failsafe.JitteredDelaySupplier;
import org.spf4j.failsafe.PartialExceptionRetryPredicate;
import org.spf4j.failsafe.PartialResultRetryPredicate;
import org.spf4j.failsafe.PartialTypedExceptionRetryPredicate;
import org.spf4j.failsafe.RetryDecision;
import org.spf4j.failsafe.RetryPredicate;
import org.spf4j.failsafe.SyncRetryExecutor;
import org.spf4j.failsafe.TimeLimitedPartialRetryPredicate;
import org.spf4j.failsafe.TimedSupplier;
import org.spf4j.failsafe.TimeoutRetryPredicate;
import org.spf4j.failsafe.TypeBasedRetryDelaySupplier;
import org.spf4j.failsafe.concurrent.DefaultFailSafeExecutor;
import org.spf4j.failsafe.concurrent.FailSafeExecutor;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public class RetryPolicy<T, C extends Callable<? extends T>>
implements SyncRetryExecutor<T, C> {
    private static final RetryPolicy<Object, Callable<? extends Object>> DEFAULT;
    private static final RetryPolicy<Object, Callable<? extends Object>> NO_RETRY;
    private final TimedSupplier<RetryPredicate<T, C>> retryPredSupplier;
    private final int maxExceptionChain;

    RetryPolicy(TimedSupplier<RetryPredicate<T, C>> retryPredicate, int maxExceptionChain) {
        this.retryPredSupplier = retryPredicate;
        this.maxExceptionChain = maxExceptionChain;
    }

    public static <T, C extends Callable<? extends T>> RetryPolicy<T, C> noRetryPolicy() {
        return NO_RETRY;
    }

    public static <T, C extends Callable<? extends T>> RetryPolicy<T, C> defaultPolicy() {
        return DEFAULT;
    }

    @Override
    public final <R extends T, W extends C, EX extends Exception> R call(W pwhat, Class<EX> exceptionClass, long startNanos, long deadlineNanos) throws InterruptedException, TimeoutException, EX {
        return (R)SyncRetryExecutor.call(pwhat, this.getRetryPredicate(startNanos, deadlineNanos), exceptionClass, this.maxExceptionChain);
    }

    public final AsyncRetryExecutor<T, C> async(FailSafeExecutor exec) {
        return new AsyncRetryExecutorImpl(this, HedgePolicy.DEFAULT, exec);
    }

    public final AsyncRetryExecutor<T, C> async(HedgePolicy hedgePolicy, FailSafeExecutor exec) {
        return new AsyncRetryExecutorImpl(this, hedgePolicy, exec);
    }

    public final AsyncRetryExecutor async() {
        return this.async(DefaultFailSafeExecutor.instance());
    }

    public final RetryPredicate<T, C> getRetryPredicate(long startTimeNanos, long deadlineNanos) {
        return new TimeoutRetryPredicate<T, C>(this.retryPredSupplier.get(startTimeNanos, deadlineNanos), deadlineNanos);
    }

    public String toString() {
        return "RetryPolicy{retryPredicate=" + this.retryPredSupplier + ", maxExceptionChain=" + this.maxExceptionChain + '}';
    }

    @CheckReturnValue
    public static <T, C extends Callable<? extends T>> Builder<T, C> newBuilder() {
        return new Builder();
    }

    @CheckReturnValue
    public static <T, C extends Callable<? extends T>> Builder<T, C> newBuilder(Builder<T, C> builder) {
        return new Builder(builder);
    }

    static {
        RetryPolicy p;
        String policySupplierClass = System.getProperty("spf4j.failsafe.defaultRetryPolicySupplier");
        if (policySupplierClass == null) {
            p = RetryPolicy.newBuilder().withDefaultThrowableRetryPredicate().withRetryOnException(Exception.class, 2).build();
        } else {
            try {
                p = (RetryPolicy)((Supplier)Class.forName(policySupplierClass).newInstance()).get();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        DEFAULT = p;
        NO_RETRY = RetryPolicy.newBuilder().build();
    }

    public static final class Builder<T, C extends Callable<? extends T>> {
        private static final int MAX_EX_CHAIN_DEFAULT = Integer.getInteger("spf4j.failsafe.defaultMaxExceptionChain", 20);
        private static final long DEFAULT_MAX_DELAY_NANOS = TimeUnit.MILLISECONDS.toNanos(Long.getLong("spf4j.failsafe.defaultMaxRetryDelayMillis", 5000L));
        private static final long DEFAULT_INITIAL_DELAY_NANOS = Long.getLong("spf4j.failsafe.defaultInitialRetryDelayNanos", 10000L);
        private static final int DEFAULT_INITIAL_NODELAY_RETRIES = Integer.getInteger("spf4j.failsafe.defaultInitialNoDelayRetries", 3);
        private static final int DEFAULT_MAX_NR_RETRIES = Integer.getInteger("spf4j.failsafe.defaultMaxNrRetries", 1000);
        private int maxExceptionChain = MAX_EX_CHAIN_DEFAULT;
        private final List<TimedSupplier<? extends PartialResultRetryPredicate<T, C>>> resultPredicates;
        private final List<TimedSupplier<? extends PartialExceptionRetryPredicate<T, C>>> exceptionPredicates;
        private int nrInitialImmediateRetries;
        private long startDelayNanos;
        private long maxDelayNanos;
        private double jitterFactor;
        private Logger log;

        private Builder() {
            this.nrInitialImmediateRetries = DEFAULT_INITIAL_NODELAY_RETRIES;
            this.startDelayNanos = DEFAULT_INITIAL_DELAY_NANOS;
            this.maxDelayNanos = DEFAULT_MAX_DELAY_NANOS;
            this.jitterFactor = 0.2;
            this.resultPredicates = new ArrayList<TimedSupplier<? extends PartialResultRetryPredicate<T, C>>>(2);
            this.exceptionPredicates = new ArrayList<TimedSupplier<? extends PartialExceptionRetryPredicate<T, C>>>(2);
            this.log = null;
        }

        private Builder(Builder from) {
            this.nrInitialImmediateRetries = from.nrInitialImmediateRetries;
            this.startDelayNanos = from.startDelayNanos;
            this.maxDelayNanos = from.maxDelayNanos;
            this.jitterFactor = from.jitterFactor;
            this.resultPredicates = new ArrayList<TimedSupplier<PartialResultRetryPredicate<T, C>>>(from.resultPredicates);
            this.exceptionPredicates = new ArrayList<TimedSupplier<PartialExceptionRetryPredicate<T, C>>>(from.exceptionPredicates);
            this.log = from.log;
        }

        public Builder<T, C> withRetryLogger(Logger plog) {
            this.log = plog;
            return this;
        }

        public Builder<T, C> withoutRetryLogger() {
            this.log = NOPLogger.NOP_LOGGER;
            return this;
        }

        public Builder<T, C> withDefaultThrowableRetryPredicate() {
            return this.withDefaultThrowableRetryPredicate(DEFAULT_MAX_NR_RETRIES);
        }

        public Builder<T, C> withDefaultThrowableRetryPredicate(int maxNrRetries) {
            return this.withExceptionPartialPredicate((e, c) -> Throwables.isRetryable(e) ? RetryDecision.retryDefault(c) : null, maxNrRetries);
        }

        public Builder<T, C> withRetryOnException(Class<? extends Exception> clasz) {
            return this.withRetryOnException(clasz, DEFAULT_MAX_NR_RETRIES);
        }

        public Builder<T, C> withRetryOnException(Class<? extends Exception> clasz, int maxRetries) {
            return this.withExceptionPartialPredicate((e, c) -> clasz.isAssignableFrom(e.getClass()) ? RetryDecision.retryDefault(c) : null, maxRetries);
        }

        public Builder<T, C> withRetryOnException(Class<? extends Exception> clasz, long maxTime, TimeUnit tu) {
            return this.withExceptionPartialPredicate((e, c) -> clasz.isAssignableFrom(e.getClass()) ? RetryDecision.retryDefault(c) : null, maxTime, tu);
        }

        public Builder<T, C> withExceptionPartialPredicate(PartialExceptionRetryPredicate<T, C> predicate, long maxTime, TimeUnit tu) {
            return this.withExceptionPartialPredicateSupplier((long s, long d) -> {
                TimeLimitedPartialRetryPredicate p = new TimeLimitedPartialRetryPredicate(s, d, maxTime, tu, predicate);
                return (value, what) -> p.apply(value, what);
            });
        }

        public Builder<T, C> withExceptionPartialPredicate(PartialExceptionRetryPredicate<T, C> predicate) {
            return this.withExceptionPartialPredicateSupplier(TimedSupplier.constant(predicate));
        }

        public <E extends Exception> Builder<T, C> withExceptionPartialPredicate(Class<E> clasz, PartialTypedExceptionRetryPredicate<T, C, E> predicate) {
            return this.withExceptionPartialPredicate((e, c) -> {
                if (clasz.isAssignableFrom(e.getClass())) {
                    return predicate.getExceptionDecision((Exception)e, c);
                }
                return null;
            });
        }

        public <E extends Exception> Builder<T, C> withExceptionPartialPredicate(Class<E> clasz, PartialTypedExceptionRetryPredicate<T, C, E> predicate, int maxRetries) {
            return this.withExceptionPartialPredicate((e, c) -> {
                if (clasz.isAssignableFrom(e.getClass())) {
                    return predicate.getExceptionDecision((Exception)e, c);
                }
                return null;
            }, maxRetries);
        }

        public Builder<T, C> withExceptionPartialPredicate(PartialExceptionRetryPredicate<T, C> predicate, int maxRetries) {
            return this.withExceptionPartialPredicateSupplier((long s, long e) -> {
                CountLimitedPartialRetryPredicate p = new CountLimitedPartialRetryPredicate(maxRetries, predicate);
                return (value, what) -> p.apply(value, what);
            });
        }

        public Builder<T, C> withExceptionPartialPredicateSupplier(Supplier<PartialExceptionRetryPredicate<T, C>> predicateSupplier) {
            return this.withExceptionPartialPredicateSupplier((long s, long e) -> (PartialExceptionRetryPredicate)predicateSupplier.get());
        }

        @Deprecated
        public Builder<T, C> withExceptionStatefulPartialPredicate(Supplier<PartialExceptionRetryPredicate<T, C>> predicateSupplier) {
            return this.withExceptionPartialPredicateSupplier(predicateSupplier);
        }

        public Builder<T, C> withExceptionPartialPredicateSupplier(TimedSupplier<PartialExceptionRetryPredicate<T, C>> predicateSupplier) {
            this.exceptionPredicates.add(predicateSupplier);
            return this;
        }

        @Deprecated
        public Builder<T, C> withExceptionStatefulPartialPredicate(TimedSupplier<PartialExceptionRetryPredicate<T, C>> predicateSupplier) {
            return this.withExceptionPartialPredicateSupplier(predicateSupplier);
        }

        public Builder<T, C> withRetryOnResult(T result, int maxRetries) {
            return this.withResultPartialPredicate((r, c) -> Objects.equals(result, r) ? RetryDecision.retryDefault(c) : null, maxRetries);
        }

        public Builder<T, C> withResultPartialPredicate(PartialResultRetryPredicate<T, C> predicate) {
            this.resultPredicates.add(TimedSupplier.constant(predicate));
            return this;
        }

        public Builder<T, C> withResultPartialPredicate(PartialResultRetryPredicate<T, C> predicate, int maxRetries) {
            return this.withResultPartialPredicateSupplier((long s, long e) -> {
                CountLimitedPartialRetryPredicate p = new CountLimitedPartialRetryPredicate(maxRetries, predicate);
                return (value, what) -> p.apply(value, what);
            });
        }

        public Builder<T, C> withResultPartialPredicateSupplier(Supplier<PartialResultRetryPredicate<T, C>> predicateSupplier) {
            return this.withResultPartialPredicateSupplier((long s, long e) -> (PartialResultRetryPredicate)predicateSupplier.get());
        }

        @Deprecated
        public Builder<T, C> withResultStatefulPartialPredicate(Supplier<PartialResultRetryPredicate<T, C>> predicateSupplier) {
            return this.withResultPartialPredicateSupplier(predicateSupplier);
        }

        public Builder<T, C> withResultPartialPredicateSupplier(TimedSupplier<PartialResultRetryPredicate<T, C>> predicateSupplier) {
            this.resultPredicates.add(predicateSupplier);
            return this;
        }

        @Deprecated
        public Builder<T, C> withResultStatefulPartialPredicate(TimedSupplier<PartialResultRetryPredicate<T, C>> predicateSupplier) {
            return this.withResultPartialPredicateSupplier(predicateSupplier);
        }

        public Builder<T, C> withJitterFactor(double jitterfactor) {
            if (this.jitterFactor > 1.0 || this.jitterFactor < 0.0) {
                throw new IllegalArgumentException("Invalid jitter factor " + jitterfactor);
            }
            this.jitterFactor = jitterfactor;
            return this;
        }

        @Deprecated
        public Builder<T, C> withInitialRetries(int retries) {
            this.nrInitialImmediateRetries = retries;
            return this;
        }

        public Builder<T, C> withInitialImmediateRetries(int retries) {
            this.nrInitialImmediateRetries = retries;
            return this;
        }

        public Builder<T, C> withInitialDelay(long delay, TimeUnit unit) {
            this.startDelayNanos = unit.toNanos(delay);
            return this;
        }

        public Builder<T, C> withMaxDelay(long delay, TimeUnit unit) {
            this.maxDelayNanos = unit.toNanos(delay);
            return this;
        }

        public Builder<T, C> withMaxExceptionChain(int maxExChain) {
            this.maxExceptionChain = maxExChain;
            return this;
        }

        @CheckReturnValue
        public Builder<T, C> copy() {
            return new Builder<T, C>(this);
        }

        @CheckReturnValue
        public RetryPolicy<T, C> build() {
            TimedSupplier[] rps = this.resultPredicates.toArray(new TimedSupplier[this.resultPredicates.size()]);
            TimedSupplier[] eps = this.exceptionPredicates.toArray(new TimedSupplier[this.exceptionPredicates.size()]);
            TimedSupplier retryPredicate = (s, e) -> new DefaultRetryPredicate(this.log, s, e, () -> new TypeBasedRetryDelaySupplier(x -> new JitteredDelaySupplier(new FibonacciRetryDelaySupplier(this.nrInitialImmediateRetries, this.startDelayNanos, this.maxDelayNanos), this.jitterFactor)), rps, eps);
            return new RetryPolicy(retryPredicate, this.maxExceptionChain);
        }

        @CheckReturnValue
        public AsyncRetryExecutor<T, C> buildAsync() {
            return this.buildAsync(DefaultFailSafeExecutor.instance());
        }

        @CheckReturnValue
        public AsyncRetryExecutor<T, C> buildAsync(FailSafeExecutor es) {
            return this.build().async(es);
        }
    }
}

