/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import org.spf4j.base.Either;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.Throwables;
import org.spf4j.base.TimeSource;
import org.spf4j.base.UncheckedExecutionException;
import org.spf4j.failsafe.RetryDecision;
import org.spf4j.failsafe.RetryPredicate;

public interface SyncRetryExecutor<T, C extends Callable<? extends T>> {
    @CheckReturnValue
    public <R extends T, W extends C, E extends Exception> R call(W var1, Class<E> var2, long var3, long var5) throws InterruptedException, TimeoutException, E;

    @CheckReturnValue
    default public <R extends T, W extends C, E extends Exception> R call(W pwhat, Class<E> exceptionClass, long deadlineNanos) throws InterruptedException, TimeoutException, E {
        return this.call(pwhat, exceptionClass, TimeSource.nanoTime(), deadlineNanos);
    }

    @CheckReturnValue
    default public <R extends T, W extends C, E extends Exception> R call(W pwhat, Class<E> exceptionClass) throws InterruptedException, TimeoutException, E {
        long nanoTime = TimeSource.nanoTime();
        return this.call(pwhat, exceptionClass, nanoTime, ExecutionContexts.getContextDeadlineNanos());
    }

    @CheckReturnValue
    default public <R extends T, W extends C, E extends Exception> R call(W pwhat, Class<E> exceptionClass, long timeout, TimeUnit tu) throws InterruptedException, TimeoutException, E {
        long nanoTime = TimeSource.nanoTime();
        return this.call(pwhat, exceptionClass, nanoTime, ExecutionContexts.computeDeadline(nanoTime, ExecutionContexts.current(), tu, timeout));
    }

    default public <W extends C, E extends Exception> void run(W pwhat, Class<E> exceptionClass) throws InterruptedException, TimeoutException, E {
        Object res = this.call(pwhat, exceptionClass);
        if (res != null) {
            throw new IllegalStateException("result must be null not " + res);
        }
    }

    default public <W extends C, E extends Exception> void run(W pwhat, Class<E> exceptionClass, long deadlineNanos) throws InterruptedException, TimeoutException, E {
        Object res = this.call(pwhat, exceptionClass, deadlineNanos);
        if (res != null) {
            throw new IllegalStateException("result must be null not " + res);
        }
    }

    default public <E extends Exception, W extends C> void run(W pwhat, Class<E> exceptionClass, long timeout, TimeUnit tu) throws InterruptedException, TimeoutException, E {
        this.run(pwhat, exceptionClass, ExecutionContexts.computeDeadline(ExecutionContexts.current(), timeout, tu));
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD", "ITC_INHERITANCE_TYPE_CHECKING"})
    public static <T, E extends Exception, C extends Callable<? extends T>> T call(C pwhat, RetryPredicate<T, C> retryPredicate, Class<E> exceptionClass, int maxExceptionChain) throws InterruptedException, TimeoutException, E {
        RetryDecision<T, C> decision;
        Throwable lastEx;
        T result;
        C what = pwhat;
        try {
            result = what.call();
            lastEx = null;
        }
        catch (InterruptedException ex1) {
            throw ex1;
        }
        catch (Throwable e) {
            lastEx = e;
            result = null;
        }
        Throwable lastExChain = lastEx;
        while (lastEx != null ? (decision = retryPredicate.getExceptionDecision(lastEx, what)).getDecisionType() == RetryDecision.Type.Retry : (decision = retryPredicate.getDecision(result, what)).getDecisionType() == RetryDecision.Type.Retry) {
            if (Thread.interrupted()) {
                InterruptedException ex = new InterruptedException();
                if (lastExChain != null) {
                    ex.addSuppressed(lastExChain);
                }
                throw ex;
            }
            long delayNanos = decision.getDelayNanos();
            if (delayNanos > 0L) {
                TimeUnit.NANOSECONDS.sleep(delayNanos);
            } else if (delayNanos < 0L) {
                throw new IllegalStateException("Invalid retry decision delay: " + delayNanos);
            }
            what = decision.getNewCallable();
            try {
                result = what.call();
                lastEx = null;
            }
            catch (InterruptedException ex1) {
                if (lastExChain != null) {
                    ex1.addSuppressed(lastExChain);
                }
                throw ex1;
            }
            catch (Exception e) {
                lastEx = e;
                result = null;
                if (lastExChain != null) {
                    Throwables.suppressLimited(lastEx, lastExChain, maxExceptionChain);
                }
                lastExChain = lastEx;
            }
        }
        if (decision.getDecisionType() == RetryDecision.Type.Abort) {
            Either<Throwable, T> r = decision.getResult();
            if (r != null) {
                if (r.isLeft()) {
                    lastEx = r.getLeft();
                    Throwable[] suppressed = lastEx.getSuppressed();
                    if (lastExChain != null && lastEx != lastExChain && (suppressed.length == 0 || suppressed[suppressed.length - 1] != lastExChain) && lastEx.getCause() != lastExChain) {
                        Throwables.suppressLimited(lastEx, lastExChain, maxExceptionChain);
                    }
                    lastExChain = lastEx;
                } else {
                    result = r.getRight();
                    lastEx = null;
                }
            }
        } else {
            throw new IllegalStateException("Should not happen, decision =  " + decision);
        }
        if (lastEx != null) {
            if (lastExChain == null) {
                lastExChain = lastEx;
            }
            if (lastExChain instanceof RuntimeException) {
                throw (RuntimeException)lastExChain;
            }
            if (lastExChain instanceof TimeoutException) {
                throw (TimeoutException)lastExChain;
            }
            if (exceptionClass.isAssignableFrom(lastExChain.getClass())) {
                throw (Exception)lastExChain;
            }
            throw new UncheckedExecutionException(lastExChain);
        }
        return result;
    }
}

