/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.TimeSource;
import org.spf4j.failsafe.RetryDecision;

@ParametersAreNonnullByDefault
final class TimeLimitedPartialRetryPredicate<T, V, C extends Callable<? extends T>>
implements BiFunction<V, C, RetryDecision<T, C>> {
    private final BiFunction<V, C, RetryDecision<T, C>> wrapped;
    private long nanosDeadline;

    TimeLimitedPartialRetryPredicate(long startTimeNanos, long deadlineNanos, long time, TimeUnit tu, BiFunction<V, C, RetryDecision<T, C>> wrapped) {
        this.wrapped = wrapped;
        long ttd = deadlineNanos - startTimeNanos;
        long tun = tu.toNanos(time);
        this.nanosDeadline = ttd < tun ? deadlineNanos : startTimeNanos + tun;
    }

    @Override
    @Nullable
    public RetryDecision<T, C> apply(V value, C what) {
        RetryDecision<T, C> decision = this.wrapped.apply(value, what);
        if (decision == null) {
            return null;
        }
        if (TimeSource.nanoTime() >= this.nanosDeadline) {
            return RetryDecision.abort();
        }
        return decision;
    }

    public String toString() {
        return "TimeLimitedPartialRetryPredicate{wrapped=" + this.wrapped + ", nanosDeadline=" + this.nanosDeadline + '}';
    }
}

