/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import org.spf4j.failsafe.Hedge;
import org.spf4j.failsafe.HedgePolicy;

public final class TimeoutRelativeHedge
implements HedgePolicy {
    private final int timeoutHedgeFraction;
    private final long minHedgeDelay;
    private final long maxHedgeDelay;
    private final int nrHedges;

    public TimeoutRelativeHedge(int timeoutHedgeFraction, long minHedgeDelayNanos, long maxHedgeDelayNanos, int nrHedges) {
        if (minHedgeDelayNanos > maxHedgeDelayNanos) {
            throw new IllegalArgumentException("Min hedge delay " + minHedgeDelayNanos + " greater than maxHedgeDelay " + maxHedgeDelayNanos);
        }
        this.timeoutHedgeFraction = timeoutHedgeFraction;
        this.minHedgeDelay = minHedgeDelayNanos;
        this.maxHedgeDelay = maxHedgeDelayNanos;
        this.nrHedges = nrHedges;
    }

    @Override
    public Hedge getHedge(long startTimeNanos, long deadlineNanos) {
        long timeoutNanos = deadlineNanos - startTimeNanos;
        if (this.minHedgeDelay >= timeoutNanos) {
            return Hedge.NONE;
        }
        long hedgeDelay = timeoutNanos / (long)this.timeoutHedgeFraction;
        if (hedgeDelay < this.minHedgeDelay) {
            return new Hedge(this.minHedgeDelay, this.nrHedges);
        }
        if (hedgeDelay > this.maxHedgeDelay) {
            return new Hedge(this.maxHedgeDelay, this.nrHedges);
        }
        return new Hedge(hedgeDelay, this.nrHedges);
    }

    public String toString() {
        return "TimeoutRelativeHedge{timeoutHedgeFraction=" + this.timeoutHedgeFraction + ", minHedgeDelay=" + this.minHedgeDelay + ", maxHedgeDelay=" + this.maxHedgeDelay + ", nrHedges=" + this.nrHedges + '}';
    }
}

