/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.spf4j.base.TimeSource;
import org.spf4j.failsafe.NotEnoughTimeToRetry;
import org.spf4j.failsafe.RetryDecision;
import org.spf4j.failsafe.RetryPredicate;

final class TimeoutRetryPredicate<T, C extends Callable<T>>
implements RetryPredicate<T, C> {
    private final RetryPredicate<T, C> predicate;
    private final long deadlineNanos;

    TimeoutRetryPredicate(RetryPredicate<T, C> predicate, long deadlineNanos) {
        this.predicate = predicate;
        this.deadlineNanos = deadlineNanos;
    }

    @Override
    public RetryDecision<T, C> getDecision(T value, C what) {
        long timeToDeadlineNanos;
        RetryDecision<T, C> decision = this.predicate.getDecision(value, what);
        if (decision.getDecisionType() == RetryDecision.Type.Retry && (timeToDeadlineNanos = TimeSource.getTimeToDeadline(this.deadlineNanos, TimeUnit.NANOSECONDS)) < decision.getDelayNanos()) {
            return RetryDecision.abortThrow(new TimeoutException("Time to deadline not enough " + timeToDeadlineNanos + " ns, last result = " + value));
        }
        return decision;
    }

    @Override
    public RetryDecision<T, C> getExceptionDecision(Throwable value, C what) {
        long timeToDeadlineNanos;
        RetryDecision<T, C> decision = this.predicate.getExceptionDecision(value, what);
        if (decision.getDecisionType() == RetryDecision.Type.Retry && (timeToDeadlineNanos = TimeSource.getTimeToDeadline(this.deadlineNanos, TimeUnit.NANOSECONDS)) < decision.getDelayNanos()) {
            value.addSuppressed(new NotEnoughTimeToRetry("Time to deadline not enough " + timeToDeadlineNanos + " ns "));
            return RetryDecision.abortThrow(value);
        }
        return decision;
    }

    public String toString() {
        return "TimeoutRetryPredicate{predicate=" + this.predicate + ", deadlineNanos=" + this.deadlineNanos + '}';
    }
}

