/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.failsafe.RetryDelaySupplier;

@ThreadSafe
public final class TypeBasedRetryDelaySupplier<T>
implements Function<T, RetryDelaySupplier> {
    private final Map<Class<T>, RetryDelaySupplier> delays = new HashMap<Class<T>, RetryDelaySupplier>(4);
    private final Function<Class<T>, RetryDelaySupplier> supplier;

    public TypeBasedRetryDelaySupplier(Function<Class<T>, RetryDelaySupplier> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetryDelaySupplier apply(T t) {
        Class<?> clasz = t.getClass();
        Map<Class<T>, RetryDelaySupplier> map = this.delays;
        synchronized (map) {
            return this.delays.computeIfAbsent(clasz, x -> this.supplier.apply((Class<Class>)x));
        }
    }

    public String toString() {
        return "TypeBasedBackoffSupplier{delays=" + this.delays + ", supplier=" + this.supplier + '}';
    }
}

