/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe.concurrent;

import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.AtomicSequence;
import org.spf4j.concurrent.Sequence;

class DelayedTask<R extends Runnable>
implements Delayed {
    private static final Sequence SEQUENCE = new AtomicSequence(0L);
    private final R runnable;
    private final long deadlineNanos;
    private final long seq;

    DelayedTask(R runnable, long delayNanos) {
        this.runnable = runnable;
        this.deadlineNanos = TimeSource.getDeadlineNanos(delayNanos, TimeUnit.NANOSECONDS);
        this.seq = SEQUENCE.next();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return TimeSource.getTimeToDeadline(this.deadlineNanos, unit);
    }

    @Override
    public int compareTo(Delayed o) {
        DelayedTask other = (DelayedTask)o;
        long diff = this.deadlineNanos - other.deadlineNanos;
        if (diff != 0L) {
            return diff > 0L ? 1 : -1;
        }
        diff = this.seq - other.seq;
        if (diff == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelayedTask other = (DelayedTask)obj;
        if (this.deadlineNanos != other.deadlineNanos) {
            return false;
        }
        return Objects.equals(this.runnable, other.runnable);
    }

    public int hashCode() {
        return this.runnable.hashCode();
    }

    public R getRunnable() {
        return this.runnable;
    }

    public String toString() {
        return "DelayedTask{runnable=" + this.runnable + ", deadlineNanos=" + this.deadlineNanos + '}';
    }
}

