/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.spf4j.base.AlmostSafe;
import sun.misc.Unsafe;

@SuppressFBWarnings
public class FutureTask<V>
implements RunnableFuture<V> {
    private volatile int state;
    private static final int NEW = 0;
    private static final int COMPLETING = 1;
    private static final int NORMAL = 2;
    private static final int EXCEPTIONAL = 3;
    private static final int CANCELLED = 4;
    private static final int INTERRUPTING = 5;
    private static final int INTERRUPTED = 6;
    private volatile Callable<V> callable;
    private Object outcome;
    private volatile Thread runner;
    private volatile WaitNode waiters;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;
    private static final long runnerOffset;
    private static final long waitersOffset;

    protected V report(int s) throws ExecutionException {
        Object x = this.outcome;
        if (s == 2) {
            return (V)x;
        }
        if (s >= 4) {
            throw new CancellationException();
        }
        throw new ExecutionException((Throwable)x);
    }

    public FutureTask(Callable<V> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.callable = callable;
        this.state = 0;
    }

    public FutureTask(Runnable runnable, V result) {
        this.callable = Executors.callable(runnable, result);
        this.state = 0;
    }

    public void setCallable(Callable<V> c) {
        if (this.callable == null) {
            throw new NullPointerException();
        }
        this.callable = c;
    }

    public void reset() {
        this.state = 0;
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    @Override
    public boolean isCancelled() {
        return this.state >= 4;
    }

    @Override
    public boolean isDone() {
        return this.state != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        block8: {
            if (this.state != 0 || !UNSAFE.compareAndSwapInt(this, stateOffset, 0, mayInterruptIfRunning ? 5 : 4)) {
                return false;
            }
            try {
                if (!mayInterruptIfRunning) break block8;
                try {
                    Thread t = this.runner;
                    if (t != null) {
                        t.interrupt();
                    }
                }
                finally {
                    UNSAFE.putOrderedInt(this, stateOffset, 6);
                }
            }
            finally {
                this.finishCompletion();
            }
        }
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        int s = this.state;
        if (s <= 1) {
            s = this.awaitDone(false, 0L);
        }
        return this.report(s);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (unit == null) {
            throw new NullPointerException();
        }
        int s = this.state;
        if (s <= 1 && (s = this.awaitDone(true, unit.toNanos(timeout))) <= 1) {
            throw new TimeoutException();
        }
        return this.report(s);
    }

    protected void done() {
    }

    protected boolean set(V v) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = v;
            UNSAFE.putOrderedInt(this, stateOffset, 2);
            this.finishCompletion();
        }
        return true;
    }

    protected boolean setException(Throwable t) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = t;
            UNSAFE.putOrderedInt(this, stateOffset, 3);
            this.finishCompletion();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            if (this.state != 0 || !UNSAFE.compareAndSwapObject(this, runnerOffset, null, Thread.currentThread())) {
                return;
            }
            boolean finished = false;
            try {
                boolean ran;
                V result;
                Callable<V> c = this.callable;
                if (c == null || this.state != 0) break block10;
                try {
                    result = c.call();
                    ran = true;
                }
                catch (Throwable ex) {
                    result = null;
                    ran = false;
                    finished = this.setException(ex);
                }
                if (ran) {
                    finished = this.set(result);
                }
            }
            finally {
                this.runner = null;
                int s = this.state;
                if (s >= 5) {
                    this.handlePossibleCancellationInterrupt(s);
                }
                if (!finished && s < 4) {
                    this.state = 0;
                } else {
                    this.callable = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runAndReset() {
        if (this.state != 0 || !UNSAFE.compareAndSwapObject(this, runnerOffset, null, Thread.currentThread())) {
            return false;
        }
        boolean ran = false;
        int s = this.state;
        try {
            Callable<V> c = this.callable;
            if (c != null && s == 0) {
                try {
                    c.call();
                    ran = true;
                }
                catch (Throwable ex) {
                    this.setException(ex);
                }
            }
        }
        finally {
            this.runner = null;
            s = this.state;
            if (s >= 5) {
                this.handlePossibleCancellationInterrupt(s);
            }
        }
        return ran && s == 0;
    }

    private void handlePossibleCancellationInterrupt(int s) {
        if (s == 5) {
            while (this.state == 5) {
                Thread.yield();
            }
        }
    }

    private void finishCompletion() {
        WaitNode q;
        block0: while ((q = this.waiters) != null) {
            if (!UNSAFE.compareAndSwapObject(this, waitersOffset, q, null)) continue;
            while (true) {
                WaitNode next;
                Thread t;
                if ((t = q.thread) != null) {
                    q.thread = null;
                    LockSupport.unpark(t);
                }
                if ((next = q.next) == null) break block0;
                q.next = null;
                q = next;
            }
        }
        this.done();
    }

    private int awaitDone(boolean timed, long nanos) throws InterruptedException {
        long deadline = timed ? System.nanoTime() + nanos : 0L;
        WaitNode q = null;
        boolean queued = false;
        while (true) {
            if (Thread.interrupted()) {
                this.removeWaiter(q);
                throw new InterruptedException();
            }
            int s = this.state;
            if (s > 1) {
                if (q != null) {
                    q.thread = null;
                }
                return s;
            }
            if (s == 1) {
                Thread.yield();
                continue;
            }
            if (q == null) {
                q = new WaitNode();
                continue;
            }
            if (!queued) {
                q.next = this.waiters;
                queued = UNSAFE.compareAndSwapObject(this, waitersOffset, q.next, q);
                continue;
            }
            if (timed) {
                nanos = deadline - System.nanoTime();
                if (nanos <= 0L) {
                    this.removeWaiter(q);
                    return this.state;
                }
                LockSupport.parkNanos(this, nanos);
                continue;
            }
            LockSupport.park(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(WaitNode node) {
        if (node != null) {
            node.thread = null;
            block0: while (true) {
                pred = null;
                q = this.waiters;
                while (q != null) {
                    s = q.next;
                    if (q.thread != null) {
                        pred = q;
                    } else if (pred != null) {
                        pred.next = s;
                        if (pred.thread == null) {
                            continue block0;
                        }
                    } else {
                        if (FutureTask.UNSAFE.compareAndSwapObject(this, FutureTask.waitersOffset, q, s)) ** break;
                        continue block0;
                    }
                    q = s;
                }
                break;
            }
        }
    }

    public String toString() {
        return "FutureTask{state=" + this.state + ", callable=" + this.callable + ", outcome=" + this.outcome + '}';
    }

    static {
        try {
            UNSAFE = AlmostSafe.USF;
            Class<FutureTask> k = FutureTask.class;
            stateOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("state"));
            runnerOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("runner"));
            waitersOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("waiters"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class WaitNode {
        volatile Thread thread = Thread.currentThread();
        volatile WaitNode next;

        WaitNode() {
        }
    }
}

