/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutionException;
import org.spf4j.base.Either;
import org.spf4j.base.Throwables;
import org.spf4j.failsafe.RetryDecision;
import org.spf4j.failsafe.RetryPredicate;
import org.spf4j.failsafe.concurrent.DelayedTask;
import org.spf4j.failsafe.concurrent.FutureTask;

class RetryFutureTask<T>
extends FutureTask<T> {
    private final RetryPredicate<T, Callable<? extends T>> retryPredicate;
    private final DelayQueue<DelayedTask<RetryFutureTask<?>>> delayedTasks;
    private Either<Throwable, T> previousResult;
    private final Runnable onRetry;
    private volatile DelayedTask<RetryFutureTask<?>> exec;

    RetryFutureTask(Callable<T> callable, RetryPredicate<T, Callable<? extends T>> retryPredicate, DelayQueue<DelayedTask<RetryFutureTask<?>>> delayedTasks, Runnable onRetry) {
        super(callable);
        this.onRetry = onRetry;
        this.retryPredicate = retryPredicate;
        this.delayedTasks = delayedTasks;
        this.previousResult = null;
    }

    public final void setExec(DelayedTask<RetryFutureTask<?>> exec) {
        this.exec = exec;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        DelayedTask<RetryFutureTask<?>> e = this.exec;
        if (e != null) {
            this.delayedTasks.remove(e);
        }
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    @SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
    protected T report(int s) throws ExecutionException {
        try {
            return (T)super.report(s);
        }
        catch (CancellationException ex) {
            RetryFutureTask retryFutureTask = this;
            synchronized (retryFutureTask) {
                CancellationException at = ex;
                if (this.previousResult != null && this.previousResult.isLeft()) {
                    Throwables.suppressLimited(at, this.previousResult.getLeft());
                }
                throw at;
            }
        }
    }

    @Override
    protected synchronized boolean setException(Throwable t) {
        if (this.isCancelled()) {
            return false;
        }
        RetryDecision decision = this.retryPredicate.getExceptionDecision(t, this.getCallable());
        RetryDecision.Type decisionType = decision.getDecisionType();
        switch (decisionType) {
            case Retry: {
                this.onRetry.run();
                long delayNanos = decision.getDelayNanos();
                this.setCallable(decision.getNewCallable());
                Throwable at = t;
                if (this.previousResult != null && this.previousResult.isLeft()) {
                    Throwables.suppressLimited(at, this.previousResult.getLeft());
                }
                this.previousResult = Either.left(at);
                DelayedTask<RetryFutureTask> delayedTask = new DelayedTask<RetryFutureTask>(this, delayNanos);
                this.exec = delayedTask;
                this.delayedTasks.add(delayedTask);
                return false;
            }
            case Abort: {
                this.exec = null;
                Either<Throwable, T> newRes = decision.getResult();
                if (newRes == null) {
                    if (this.previousResult != null && this.previousResult.isLeft()) {
                        Throwables.suppressLimited(t, this.previousResult.getLeft());
                    }
                    super.setException(t);
                } else if (newRes.isLeft()) {
                    Throwable tx = newRes.getLeft();
                    if (this.previousResult != null && this.previousResult.isLeft()) {
                        Throwables.suppressLimited(tx, this.previousResult.getLeft());
                    }
                    super.setException(tx);
                } else {
                    super.set(newRes.getRight());
                }
                return true;
            }
        }
        throw new IllegalStateException("Invalid decision type" + (Object)((Object)decisionType), t);
    }

    @Override
    protected synchronized boolean set(T v) {
        if (this.isCancelled()) {
            return false;
        }
        RetryDecision decision = this.retryPredicate.getDecision(v, this.getCallable());
        RetryDecision.Type decisionType = decision.getDecisionType();
        switch (decisionType) {
            case Retry: {
                this.onRetry.run();
                long delayNanos = decision.getDelayNanos();
                this.setCallable(decision.getNewCallable());
                DelayedTask<RetryFutureTask> delayedTask = new DelayedTask<RetryFutureTask>(this, delayNanos);
                this.exec = delayedTask;
                this.delayedTasks.add(delayedTask);
                this.previousResult = Either.right(v);
                return false;
            }
            case Abort: {
                this.exec = null;
                Either<Throwable, T> newRes = decision.getResult();
                if (newRes == null) {
                    super.set(v);
                } else if (newRes.isLeft()) {
                    super.setException(newRes.getLeft());
                } else {
                    super.set(newRes.getRight());
                }
                return true;
            }
        }
        throw new IllegalStateException("Invalid decision type" + (Object)((Object)decisionType));
    }
}

