/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.spf4j.recyclable.impl.ArraySuppliers;

@CleanupObligation
public class AppendableOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Appendable writer;
    private final CharsetDecoder decoder;
    private ByteBuffer decoderIn;
    protected CharBuffer decoderOut;

    public AppendableOutputStream(Appendable writer, CharsetDecoder decoder) {
        this(writer, decoder, 8192);
    }

    public AppendableOutputStream(Appendable writer, CharsetDecoder decoder, int bufferSize) {
        AppendableOutputStream.checkIbmJdkWithBrokenUTF16(decoder.charset());
        this.writer = writer;
        this.decoder = decoder;
        this.decoderIn = ByteBuffer.wrap(ArraySuppliers.Bytes.TL_SUPPLIER.get(256));
        this.decoderOut = CharBuffer.wrap(ArraySuppliers.Chars.TL_SUPPLIER.get(bufferSize));
    }

    public AppendableOutputStream(Appendable writer, Charset charset, int bufferSize) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), bufferSize);
    }

    public AppendableOutputStream(Appendable writer, Charset charset) {
        this(writer, charset, 8192);
    }

    public AppendableOutputStream(Appendable writer, String charsetName, int bufferSize) {
        this(writer, Charset.forName(charsetName), bufferSize);
    }

    public AppendableOutputStream(Appendable writer, String charsetName) {
        this(writer, charsetName, 8192);
    }

    @Override
    public void write(byte[] b, int poff, int plen) throws IOException {
        int len = plen;
        int off = poff;
        while (len > 0) {
            int c = Math.min(len, this.decoderIn.remaining());
            this.decoderIn.put(b, off, c);
            this.processInput(false);
            len -= c;
            off += c;
        }
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public final void write(int b) throws IOException {
        int c = Math.min(1, this.decoderIn.remaining());
        if (c > 0) {
            this.decoderIn.put((byte)b);
            this.processInput(false);
        } else {
            this.processInput(false);
            this.decoderIn.put((byte)b);
            this.processInput(false);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushOutput();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        if (this.decoderIn != null) {
            this.processInput(true);
            this.flushOutput();
            ArraySuppliers.Bytes.TL_SUPPLIER.recycle(this.decoderIn.array());
            ArraySuppliers.Chars.TL_SUPPLIER.recycle(this.decoderOut.array());
            this.decoderIn = null;
            this.decoderOut = null;
        }
    }

    protected void processInput(boolean endOfInput) throws IOException {
        CoderResult coderResult;
        this.decoderIn.flip();
        while ((coderResult = this.decoder.decode(this.decoderIn, this.decoderOut, endOfInput)).isOverflow()) {
            this.flushOutput();
        }
        if (!coderResult.isUnderflow()) {
            throw new IOException("Unexpected coder result " + coderResult);
        }
        this.decoderIn.compact();
    }

    protected void flushOutput() throws IOException {
        int position = this.decoderOut.position();
        if (position > 0) {
            this.decoderOut.position(0);
            int limit = this.decoderOut.limit();
            this.decoderOut.limit(position);
            this.writer.append(this.decoderOut);
            this.decoderOut.rewind();
            this.decoderOut.limit(limit);
        }
    }

    private static void checkIbmJdkWithBrokenUTF16(Charset charset) {
        if (!"UTF-16".equals(charset.name())) {
            return;
        }
        String testString2 = "v\u00e9s";
        byte[] bytes = "v\u00e9s".getBytes(charset);
        CharsetDecoder charsetDecoder2 = charset.newDecoder();
        ByteBuffer bb2 = ByteBuffer.allocate(16);
        CharBuffer cb2 = CharBuffer.allocate("v\u00e9s".length());
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            bb2.put(bytes[i]);
            bb2.flip();
            try {
                charsetDecoder2.decode(bb2, cb2, i == len - 1);
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException("UTF-16 requested when runninng on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UF-16 with WriterOutputStream", e);
            }
            bb2.compact();
        }
        cb2.rewind();
        if (!"v\u00e9s".equals(cb2.toString())) {
            throw new UnsupportedOperationException("UTF-16 requested when runninng on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UF-16 with WriterOutputStream");
        }
    }

    public String toString() {
        return "AppendableOutputStream{writer=" + this.writer + '}';
    }
}

