/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.spf4j.recyclable.SizedRecyclingSupplier;
import org.spf4j.recyclable.impl.ArraySuppliers;

@CleanupObligation
@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public final class ByteArrayBuilder
extends OutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] buf;
    private int count;
    private final SizedRecyclingSupplier<byte[]> arraySupplier;

    public ByteArrayBuilder() {
        this(256, ArraySuppliers.Bytes.TL_SUPPLIER);
    }

    public ByteArrayBuilder(int size) {
        this(size, ArraySuppliers.Bytes.TL_SUPPLIER);
    }

    public synchronized byte[] getBuffer() {
        return this.buf;
    }

    public ByteArrayBuilder(int size, SizedRecyclingSupplier<byte[]> arraySupplier) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.arraySupplier = arraySupplier;
        this.buf = arraySupplier == null ? (size == 0 ? org.spf4j.base.Arrays.EMPTY_BYTE_ARRAY : new byte[size]) : arraySupplier.get(size);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ByteArrayBuilder.hugeCapacity(minCapacity);
        }
        if (this.arraySupplier == null) {
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        } else {
            byte[] old = this.buf;
            this.buf = this.arraySupplier.get(newCapacity);
            System.arraycopy(old, 0, this.buf, 0, old.length);
            this.arraySupplier.recycle(old);
        }
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(int b) {
        int cp1 = this.count + 1;
        this.ensureCapacity(cp1);
        this.buf[this.count] = (byte)b;
        this.count = cp1;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        int cpl = this.count + len;
        this.ensureCapacity(cpl);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = cpl;
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized void resetCountTo(int pos) {
        this.count = pos;
    }

    public synchronized byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        return this.toString(StandardCharsets.UTF_8);
    }

    public synchronized String toString(Charset charset) {
        return new String(this.buf, 0, this.count, charset);
    }

    @Override
    @DischargesObligation
    public synchronized void close() {
        if (this.arraySupplier != null) {
            this.arraySupplier.recycle(this.buf);
        }
    }
}

