/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.CoreTextMediaType;
import org.spf4j.io.ObjectAppender;
import org.spf4j.io.ObjectAppenderSupplier;
import org.spf4j.reflect.CachingTypeMapWrapper;
import org.spf4j.reflect.GraphTypeMap;

@ParametersAreNonnullByDefault
@Beta
@ThreadSafe
public final class ConfigurableAppenderSupplier
implements ObjectAppenderSupplier {
    private final CachingTypeMapWrapper<ObjectAppender>[] appenderMap = new CachingTypeMapWrapper[CoreTextMediaType.values().length];

    public ConfigurableAppenderSupplier() {
        this(true, t -> false, new ObjectAppender[0]);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public ConfigurableAppenderSupplier(boolean registerFromServiceLoader, Predicate<Class<?>> except, ObjectAppender<?> ... appenders) {
        for (int i = 0; i < this.appenderMap.length; ++i) {
            this.appenderMap[i] = new CachingTypeMapWrapper(new GraphTypeMap());
        }
        if (registerFromServiceLoader) {
            ServiceLoader<ObjectAppender> load = ServiceLoader.load(ObjectAppender.class);
            for (ObjectAppender appender : load) {
                Class<?> appenderType = ConfigurableAppenderSupplier.getAppenderType(appender);
                if (except.test(appenderType) || this.tryRegister(appenderType, appender)) continue;
                throw new IllegalArgumentException("Attempting to register duplicate appender(" + appender + ") for " + appenderType);
            }
        }
        for (ObjectAppender<?> appender : appenders) {
            if (this.tryRegister(ConfigurableAppenderSupplier.getAppenderType(appender), appender)) continue;
            throw new IllegalArgumentException("Cannot register appender " + appender);
        }
        this.appenderMap[ObjectAppender.TOSTRING_APPENDER.getAppendedType().ordinal()].putIfNotPresent((Type)((Object)Object.class), ObjectAppender.TOSTRING_APPENDER);
    }

    public static Class<?> getAppenderType(ObjectAppender<?> appender) {
        Class<?> aClass = appender.getClass();
        Class appenderType = null;
        do {
            Type[] genericInterfaces;
            for (Type type : genericInterfaces = aClass.getGenericInterfaces()) {
                ParameterizedType pType;
                if (!(type instanceof ParameterizedType) || (pType = (ParameterizedType)type).getRawType() != ObjectAppender.class) continue;
                Type actualTypeArgument = pType.getActualTypeArguments()[0];
                if (actualTypeArgument instanceof ParameterizedType) {
                    appenderType = (Class)((ParameterizedType)actualTypeArgument).getRawType();
                    break;
                }
                appenderType = (Class)actualTypeArgument;
                break;
            }
            aClass = aClass.getSuperclass();
        } while (appenderType == null && aClass != null);
        if (appenderType == null) {
            throw new IllegalArgumentException("Improperly declared Appender " + appender);
        }
        return appenderType;
    }

    public <T> int register(Class<T> type, ObjectAppender<? super T> ... appenders) {
        int i = 0;
        for (ObjectAppender<? super T> appender : appenders) {
            if (!this.tryRegister(type, appender)) continue;
            ++i;
        }
        return i;
    }

    public <T> void replace(CoreTextMediaType mt, Class<T> type, Function<ObjectAppender<? super T>, ObjectAppender<? super T>> replace) {
        this.appenderMap[mt.ordinal()].replace(type, replace);
    }

    public <T> void register(Class<T> type, ObjectAppender<? super T> appender) {
        if (!this.tryRegister(type, appender)) {
            throw new IllegalArgumentException("Cannnot Register " + appender + " for " + type);
        }
    }

    @CheckReturnValue
    public <T> boolean tryRegister(Class<T> type, ObjectAppender<? super T> appender) {
        return this.appenderMap[appender.getAppendedType().ordinal()].putIfNotPresent(type, appender);
    }

    public <T> void register(Class<T> type, CoreTextMediaType contentType, ObjectAppender<? super T> appender) {
        if (!this.tryRegister(type, contentType, appender)) {
            throw new IllegalArgumentException("Cannnot Register " + appender + " for " + type);
        }
    }

    @CheckReturnValue
    public <T> boolean tryRegister(Class<T> type, CoreTextMediaType contentType, ObjectAppender<? super T> appender) {
        return this.appenderMap[contentType.ordinal()].putIfNotPresent(type, new ObjectAppenderContentTypeAdapter<T>(appender, contentType));
    }

    public boolean unregister(Class<?> type) {
        boolean result = false;
        int l = CoreTextMediaType.values().length;
        for (int i = 0; i < l; ++i) {
            boolean removed = this.appenderMap[i].remove(type);
            if (!removed) continue;
            result = true;
        }
        return result;
    }

    @Override
    public ObjectAppender get(CoreTextMediaType mt, Type type) {
        return (ObjectAppender)this.appenderMap[mt.ordinal()].get(type);
    }

    public String toString() {
        return "ConfigurableAppenderSupplier{lookup=" + Arrays.toString(this.appenderMap) + '}';
    }

    private static final class ObjectAppenderContentTypeAdapter<T>
    implements ObjectAppender<T> {
        private final ObjectAppender<? super T> appender;
        private final CoreTextMediaType contentType;

        ObjectAppenderContentTypeAdapter(ObjectAppender<? super T> appender, CoreTextMediaType contentType) {
            this.appender = appender;
            this.contentType = contentType;
        }

        @Override
        public void append(T object, Appendable appendTo) throws IOException {
            this.appender.append(object, appendTo);
        }

        @Override
        public void append(T object, Appendable appendTo, ObjectAppenderSupplier appenderSupplier) throws IOException {
            this.appender.append(object, appendTo, appenderSupplier);
        }

        @Override
        public CoreTextMediaType getAppendedType() {
            return this.contentType;
        }
    }
}

