/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.spf4j.base.Wrapper;

public final class CountingInputStream
extends FilterInputStream
implements Wrapper<InputStream> {
    private long count;
    private long mark = -1L;

    public CountingInputStream(@Nonnull InputStream in, long count) {
        super(in);
        this.count = count;
    }

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public synchronized long getCount() {
        return this.count;
    }

    @Override
    public synchronized int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            ++this.count;
        }
        return result;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.count += (long)result;
        }
        return result;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.count += result;
        return result;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.count;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported by " + this.in);
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set for " + this);
        }
        this.in.reset();
        this.count = this.mark;
    }

    public String toString() {
        return "CountingInputStream{count=" + this.count + ", mark=" + this.mark + '}';
    }

    @Override
    public InputStream getWrapped() {
        return this.in;
    }
}

