/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.CharSequences;
import org.spf4j.io.PushbackReader;
import org.spf4j.io.csv.CharSeparatedValues;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.io.csv.CsvReader;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
public final class Csv {
    public static final CharSeparatedValues CSV = new CharSeparatedValues(',');
    private static final char[] TO_ESCAPE = new char[]{',', '\n', '\r', '\"'};

    private Csv() {
    }

    public static String[] readSystemProperty(String propertyName, String ... defaults) {
        List<String> row;
        String propertyVal = System.getProperty(propertyName);
        if (propertyVal == null) {
            return defaults;
        }
        try {
            row = Csv.readRow(propertyVal);
        }
        catch (CsvParseException ex) {
            throw new RuntimeException("Unable to parser property " + propertyName + " = " + propertyVal, ex);
        }
        return row.toArray(new String[row.size()]);
    }

    public static void writeCsvRow(Appendable writer, Object ... elems) throws IOException {
        CSV.writeCsvRow(writer, elems);
    }

    public static void writeCsvRow2(Appendable writer, Object obj, Object ... elems) throws IOException {
        CSV.writeCsvRow2(writer, obj, elems);
    }

    public static void writeCsvRow(Appendable writer, long ... elems) throws IOException {
        CSV.writeCsvRow(writer, elems);
    }

    public static void writeCsvRowNoEOL(long[] elems, Appendable writer) throws IOException {
        CSV.writeCsvRowNoEOL(elems, writer);
    }

    public static void writeCsvRow(Appendable writer, Iterable<?> elems) throws IOException {
        CSV.writeCsvRow(writer, elems);
    }

    public static void writeCsvRowNoEOL(Iterable<?> elems, Appendable writer) throws IOException {
        CSV.writeCsvRowNoEOL(elems, writer);
    }

    public static <T> T read(File file, Charset charset, CsvMapHandler<T> handler) throws IOException, CsvParseException {
        return CSV.read(file, charset, handler);
    }

    public static <T> T read(File file, Charset charset, CsvHandler<T> handler) throws IOException, CsvParseException {
        return CSV.read(file, charset, handler);
    }

    public static List<Map<String, String>> read(Reader preader) throws IOException, CsvParseException {
        return CSV.read(preader);
    }

    public static <T> T read(Reader preader, CsvMapHandler<T> handler) throws IOException, CsvParseException {
        return CSV.read(preader, handler);
    }

    public static List<String> readRow(String row) throws CsvParseException {
        try {
            return Csv.readRow(new StringReader(row));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static List<String> readRow(Reader reader) throws IOException, CsvParseException {
        return CSV.readRow(reader);
    }

    public static <T> T readRow(Reader reader, CsvRowHandler<T> handler) throws IOException, CsvParseException {
        return CSV.readRow(reader, handler);
    }

    public static <T> T read(Reader preader, CsvHandler<T> handler) throws IOException, CsvParseException {
        return CSV.read(preader, handler);
    }

    public static <T> T readNoBom(PushbackReader reader, CsvHandler<T> handler) throws IOException, CsvParseException {
        return CSV.readNoBom(reader, handler);
    }

    public static Iterable<Iterable<String>> asIterable(Reader preader) {
        return CSV.asIterable(preader);
    }

    public static CsvReader reader(Reader preader) throws IOException {
        return CSV.reader(preader);
    }

    public static CsvReader readerNoBOM(PushbackReader reader) {
        return CSV.readerNoBOM(reader);
    }

    public static void writeCsvElement(CharSequence elem, Appendable writer) throws IOException {
        if (CharSequences.containsAnyChar(elem, TO_ESCAPE)) {
            Csv.writeQuotedCsvElement(elem, writer);
        } else {
            writer.append(elem);
        }
    }

    public static void writeQuotedCsvElement(CharSequence elem, Appendable writer) throws IOException {
        int length = elem.length();
        writer.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = elem.charAt(i);
            if (c == '\"') {
                writer.append("\"\"");
                continue;
            }
            writer.append(c);
        }
        writer.append('\"');
    }

    public static CharSequence toCsvElement(CharSequence elem) {
        if (CharSequences.containsAnyChar(elem, TO_ESCAPE)) {
            StringBuilder sw = new StringBuilder(elem.length() + 2);
            try {
                Csv.writeQuotedCsvElement(elem, sw);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return sw.toString();
        }
        return elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckReturnValue
    public static int readCsvElement(Reader reader, StringBuilder addElemTo) throws IOException {
        int c = reader.read();
        if (c < 0) {
            return c;
        }
        if (c == 34) {
            c = reader.read();
            while (c >= 0) {
                if (c == 34) {
                    int c2 = reader.read();
                    if (c2 < 0) return c2;
                    if (c2 != 34) return c2;
                    addElemTo.append((char)c);
                } else {
                    addElemTo.append((char)c);
                }
                c = reader.read();
            }
            return c;
        } else {
            while (c != 44 && c != 10 && c != 13 && c >= 0) {
                addElemTo.append((char)c);
                c = reader.read();
            }
        }
        return c;
    }

    public static interface CsvMapHandler<T>
    extends org.spf4j.io.csv.CsvMapHandler<T> {
    }

    public static interface CsvRowHandler<T>
    extends org.spf4j.io.csv.CsvRowHandler<T> {
    }

    public static interface CsvHandler<T>
    extends org.spf4j.io.csv.CsvHandler<T> {
    }
}

