/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.spf4j.io.Streams;

public final class DebugInputStream
extends InputStream {
    private final InputStream source;
    private final File destination;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public DebugInputStream(InputStream wrapped, File destinationDir) throws IOException {
        this.destination = File.createTempFile("stream", ".tmp", destinationDir);
        Path toPath = this.destination.toPath();
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(toPath, new OpenOption[0]));){
            Streams.copy(wrapped, os);
        }
        this.source = new BufferedInputStream(Files.newInputStream(toPath, new OpenOption[0]));
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.source.reset();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.source.mark(readlimit);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.source.skip(n);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.source.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.source.read();
    }

    public String toString() {
        return "DebugInputStream{source=" + this.source + ", destination=" + this.destination + '}';
    }
}

