/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.DateTimeFormats;
import org.spf4j.base.Timing;

public class IOTimeoutException
extends IOException {
    private final long deadlineNanos;
    private final long nanosAfterDeadline;

    public IOTimeoutException(long deadlineNanos, long nanosAfterDeadline) {
        super("Timeout encountered, " + nanosAfterDeadline + " ns after deadline: " + DateTimeFormats.TS_FORMAT.format(Instant.ofEpochMilli(Timing.getCurrentTiming().fromNanoTimeToEpochMillis(deadlineNanos))));
        this.deadlineNanos = deadlineNanos;
        this.nanosAfterDeadline = nanosAfterDeadline;
    }

    @Deprecated
    public final long getDeadline() {
        return this.deadlineNanos;
    }

    public final long getDeadlineNanos() {
        return this.deadlineNanos;
    }

    public final long getMillisAfterDeadline() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanosAfterDeadline);
    }

    public final long getNanosAfterDeadline() {
        return this.nanosAfterDeadline;
    }
}

