/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.io.BaseEncoding;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Arrays;
import org.spf4j.recyclable.SizedRecyclingSupplier;
import org.spf4j.recyclable.impl.ArraySuppliers;

@ParametersAreNonnullByDefault
@CleanupObligation
public final class MemorizingBufferedInputStream
extends FilterInputStream {
    private byte[] memory;
    private final SizedRecyclingSupplier<byte[]> bufferProvider;
    private final int readSize;
    private final Charset charset;
    private int memIdx;
    private int startIdx;
    private int endIdx;
    private boolean isEof;
    private boolean isClosed;
    private long readBytes;

    public MemorizingBufferedInputStream(InputStream in) {
        this(in, 16384, 8192, ArraySuppliers.Bytes.GL_SUPPLIER, null);
    }

    public MemorizingBufferedInputStream(InputStream in, int size) {
        this(in, size, size / 2, ArraySuppliers.Bytes.GL_SUPPLIER, null);
    }

    public MemorizingBufferedInputStream(InputStream in, Charset charset) {
        this(in, 16384, 8192, ArraySuppliers.Bytes.GL_SUPPLIER, charset);
    }

    public MemorizingBufferedInputStream(InputStream in, Charset charset, int size) {
        this(in, size, size / 2, ArraySuppliers.Bytes.GL_SUPPLIER, charset);
    }

    public MemorizingBufferedInputStream(InputStream in, int size, int readSize, SizedRecyclingSupplier<byte[]> bufferProvider, @Nullable Charset charset) {
        super(in);
        if (readSize > size) {
            throw new IllegalArgumentException("Read size " + readSize + " cannot be greater than " + size);
        }
        if (size < 2) {
            throw new IllegalArgumentException("Buffer size " + size + " cannot be smaler than 2");
        }
        this.memory = bufferProvider.get(size);
        this.bufferProvider = bufferProvider;
        this.charset = charset;
        this.startIdx = 0;
        this.endIdx = 0;
        this.readSize = readSize;
        this.isEof = false;
        this.isClosed = false;
        this.readBytes = 0L;
    }

    @Override
    @DischargesObligation
    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.bufferProvider.recycle(this.memory);
            this.memory = null;
            super.close();
        }
    }

    private int availableToWrite() {
        if (this.memIdx <= this.endIdx) {
            return this.memIdx + this.memory.length - this.endIdx - 1;
        }
        return this.memIdx - this.endIdx - 1;
    }

    private int availableToRead() {
        if (this.startIdx <= this.endIdx) {
            return this.endIdx - this.startIdx;
        }
        return this.memory.length - this.startIdx + this.endIdx;
    }

    private int availableInMemory() {
        if (this.memIdx <= this.startIdx) {
            return this.startIdx - this.memIdx;
        }
        return this.memory.length - this.memIdx + this.startIdx;
    }

    public synchronized byte[] getReadBytesFromBuffer() {
        int availableInMemory = this.availableInMemory();
        if (availableInMemory == 0) {
            return Arrays.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[availableInMemory];
        if (this.memIdx < this.startIdx) {
            System.arraycopy(this.memory, this.memIdx, result, 0, result.length);
        } else {
            int toEnd = this.memory.length - this.memIdx;
            System.arraycopy(this.memory, this.memIdx, result, 0, toEnd);
            System.arraycopy(this.memory, 0, result, toEnd, this.startIdx);
        }
        return result;
    }

    public synchronized byte[] getUnreadBytesFromBuffer() {
        int availableToRead = this.availableToRead();
        if (availableToRead == 0) {
            return Arrays.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[availableToRead];
        if (this.startIdx < this.endIdx) {
            System.arraycopy(this.memory, this.startIdx, result, 0, result.length);
        } else {
            int toEnd = this.memory.length - this.startIdx;
            System.arraycopy(this.memory, this.startIdx, result, 0, toEnd);
            System.arraycopy(this.memory, 0, result, toEnd, this.endIdx);
        }
        return result;
    }

    private int tryCleanup(int size) {
        int canWrite = this.availableToWrite();
        if (canWrite < size) {
            int toFree = size - canWrite;
            int availableToFree = this.availableInMemory();
            if (toFree > availableToFree) {
                toFree = availableToFree;
            }
            this.memIdx += toFree;
            if (this.memIdx >= this.memory.length) {
                this.memIdx -= this.memory.length;
            }
            return toFree + canWrite;
        }
        return size;
    }

    private void fill() throws IOException {
        int size = this.tryCleanup(this.readSize);
        if (size < this.readSize) {
            throw new IllegalStateException("Illegal state " + this);
        }
        int canWriteInBulk = Math.min(size, this.memory.length - this.endIdx);
        int read = super.read(this.memory, this.endIdx, canWriteInBulk);
        if (read < 0) {
            this.isEof = true;
            return;
        }
        this.endIdx += read;
        if (read < canWriteInBulk) {
            return;
        }
        int wrapArround = size - canWriteInBulk;
        if (wrapArround > 0) {
            read = super.read(this.memory, 0, wrapArround);
            if (read < 0) {
                if (this.endIdx >= this.memory.length) {
                    this.endIdx = 0;
                }
                this.isEof = true;
                return;
            }
            this.endIdx = read;
        } else if (this.endIdx >= this.memory.length) {
            this.endIdx = 0;
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed " + this);
        }
        if (len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException("Offset " + off + " or len " + len);
        }
        int availableToRead = this.availableToRead();
        if (availableToRead <= 0) {
            this.fill();
            availableToRead = this.availableToRead();
        }
        if (availableToRead == 0) {
            if (this.isEof) {
                return -1;
            }
            throw new IllegalStateException("State=" + this);
        }
        int toRead = Math.min(availableToRead, len);
        int readToEnd = Math.min(toRead, this.memory.length - this.startIdx);
        System.arraycopy(this.memory, this.startIdx, b, off, readToEnd);
        this.startIdx += readToEnd;
        int wrapArround = toRead - readToEnd;
        if (wrapArround > 0) {
            System.arraycopy(this.memory, 0, b, off + readToEnd, wrapArround);
            this.startIdx = wrapArround;
        } else if (this.startIdx >= this.memory.length) {
            this.startIdx = 0;
        }
        this.readBytes += (long)toRead;
        return toRead;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed " + this);
        }
        int availableToRead = this.availableToRead();
        if (availableToRead <= 0) {
            this.fill();
            availableToRead = this.availableToRead();
        }
        if (availableToRead == 0) {
            if (this.isEof) {
                return -1;
            }
            throw new IllegalStateException("State=" + this);
        }
        int result = this.memory[this.startIdx++] & 0xFF;
        if (this.startIdx >= this.memory.length) {
            this.startIdx = 0;
        }
        ++this.readBytes;
        return result;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed " + this);
        }
        return this.availableToRead();
    }

    public synchronized String toString() {
        StringBuilder result = this.isClosed ? new StringBuilder(64) : new StringBuilder((this.availableToRead() + this.availableInMemory()) * 2 + 128);
        result.append("MemorizingBufferedInputStream{\n");
        if (this.isClosed) {
            result.append("closed=true\n");
        } else if (this.charset == null) {
            BaseEncoding base64 = BaseEncoding.base64();
            result.append("readBytes=\"").append(base64.encode(this.getReadBytesFromBuffer())).append("\",\n");
            result.append("unreadBytes=\"").append(base64.encode(this.getUnreadBytesFromBuffer())).append("\"\n");
        } else {
            try {
                result.append("readStr=\"").append(this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?").decode(ByteBuffer.wrap(this.getReadBytesFromBuffer()))).append("\",\n");
                result.append("unreadStr=\"").append(this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?").decode(ByteBuffer.wrap(this.getUnreadBytesFromBuffer()))).append("\"\n");
            }
            catch (CharacterCodingException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        result.append("memIdx=").append(this.memIdx).append("\"\n");
        result.append("startIdx=").append(this.startIdx).append("\"\n");
        result.append("endIdx=").append(this.endIdx).append("\"\n");
        result.append('}');
        return result.toString();
    }

    public synchronized long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        int read;
        long nrSkipped = 0L;
        int i = 0;
        while ((long)i < n && (read = this.read()) >= 0) {
            ++nrSkipped;
            ++i;
        }
        return nrSkipped;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }
}

