/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ConcurrentModificationException;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.CoreTextMediaType;
import org.spf4j.base.EscapeJsonStringAppendableWrapper;
import org.spf4j.io.ObjectAppenderSupplier;

@ParametersAreNonnullByDefault
@FunctionalInterface
public interface ObjectAppender<T>
extends BiConsumer<T, Appendable> {
    public static final ObjectAppender<Object> TOSTRING_APPENDER = new ObjectAppender<Object>(){

        @Override
        public void append(Object object, Appendable appendTo) throws IOException {
            String toString = null;
            int i = 10;
            do {
                try {
                    toString = object.toString();
                }
                catch (ConcurrentModificationException ex) {
                    --i;
                }
            } while (toString == null && i > 0);
            if (i != 10) {
                appendTo.append("ConcurrentlyModifiedDuringToString:");
            }
            if (toString == null) {
                appendTo.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
            } else {
                appendTo.append(toString);
            }
        }
    };

    default public CoreTextMediaType getAppendedType() {
        return CoreTextMediaType.TEXT_PLAIN;
    }

    public void append(T var1, Appendable var2) throws IOException;

    public static void appendNullable(@Nullable Object o, Appendable appendTo, ObjectAppenderSupplier appenderSupplier) throws IOException {
        if (o == null) {
            appendTo.append("null");
        } else {
            appenderSupplier.get(o.getClass()).append(o, appendTo, appenderSupplier);
        }
    }

    public static void appendNullableJson(@Nullable Object o, Appendable appendTo, ObjectAppenderSupplier appenderSupplier) throws IOException {
        if (o == null) {
            appendTo.append("null");
        } else {
            ObjectAppender app = appenderSupplier.get(CoreTextMediaType.APPLICATION_JSON, o.getClass());
            if (app != null) {
                app.append(o, appendTo, appenderSupplier);
            } else {
                app = appenderSupplier.get(CoreTextMediaType.TEXT_PLAIN, o.getClass());
                EscapeJsonStringAppendableWrapper sEsc = new EscapeJsonStringAppendableWrapper(appendTo);
                appendTo.append('\"');
                app.append(o, sEsc, appenderSupplier);
                appendTo.append('\"');
            }
        }
    }

    default public void append(T object, Appendable appendTo, ObjectAppenderSupplier appenderSupplier) throws IOException {
        this.append(object, appendTo);
    }

    @Override
    default public void accept(T object, Appendable appendTo) {
        try {
            this.append(object, appendTo);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

