/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.appenders.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ExtendedJsonEncoder;
import org.spf4j.io.AppendableWriter;

public final class JsonEncoderFactory {
    private static final EncoderSupplier DECODER_SUPPLIER;

    private JsonEncoderFactory() {
    }

    public static Encoder getEncoder(Schema writerSchema, OutputStream os) throws IOException {
        return DECODER_SUPPLIER.getEncoder(writerSchema, os);
    }

    public static Encoder getEncoder(Schema writerSchema, Appendable os) throws IOException {
        return DECODER_SUPPLIER.getEncoder(writerSchema, os);
    }

    static {
        Class<?> clasz = null;
        try {
            clasz = Class.forName("org.apache.avro.io.ExtendedJsonDecoder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DECODER_SUPPLIER = clasz == null ? new EncoderSupplier(){
            private EncoderFactory factory = EncoderFactory.get();

            @Override
            public Encoder getEncoder(Schema writerSchema, OutputStream os) throws IOException {
                return this.factory.jsonEncoder(writerSchema, os);
            }

            @Override
            public Encoder getEncoder(Schema writerSchema, Appendable os) throws IOException {
                return this.factory.jsonEncoder(writerSchema, (Writer)new AppendableWriter(os));
            }
        } : new EncoderSupplier(){

            @Override
            public Encoder getEncoder(Schema writerSchema, OutputStream os) throws IOException {
                return new ExtendedJsonEncoder(writerSchema, os);
            }

            @Override
            public Encoder getEncoder(Schema writerSchema, Appendable os) throws IOException {
                return new ExtendedJsonEncoder(writerSchema, Schema.FACTORY.createGenerator((Writer)new AppendableWriter(os)));
            }
        };
    }

    static interface EncoderSupplier {
        public Encoder getEncoder(Schema var1, OutputStream var2) throws IOException;

        public Encoder getEncoder(Schema var1, Appendable var2) throws IOException;
    }
}

