/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.appenders.json;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.spf4j.base.CoreTextMediaType;
import org.spf4j.base.EscapeJsonStringAppendableWrapper;
import org.spf4j.io.ObjectAppender;
import org.spf4j.io.ObjectAppenderSupplier;

public final class MapJsonAppender
implements ObjectAppender<Map<Object, Object>> {
    @Override
    public CoreTextMediaType getAppendedType() {
        return CoreTextMediaType.APPLICATION_JSON;
    }

    @Override
    public void append(Map<Object, Object> map, Appendable appendTo, ObjectAppenderSupplier appenderSupplier) throws IOException {
        appendTo.append('[');
        Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
        Iterator<Map.Entry<Object, Object>> it = entrySet.iterator();
        if (it.hasNext()) {
            Map.Entry<Object, Object> o = it.next();
            MapJsonAppender.appendEntry(o, appendTo, appenderSupplier);
            while (it.hasNext()) {
                o = it.next();
                appendTo.append(',');
                MapJsonAppender.appendEntry(o, appendTo, appenderSupplier);
            }
        }
        appendTo.append(']');
    }

    private static void appendEntry(Map.Entry<Object, Object> o, Appendable appendTo, ObjectAppenderSupplier appenderSupplier) throws IOException {
        Object key = o.getKey();
        Object value = o.getValue();
        if (key instanceof CharSequence) {
            appendTo.append("{\"");
            EscapeJsonStringAppendableWrapper sEsc = new EscapeJsonStringAppendableWrapper(appendTo);
            appenderSupplier.get(key.getClass()).append(key, sEsc, appenderSupplier);
            appendTo.append("\":");
            ObjectAppender.appendNullableJson(value, appendTo, appenderSupplier);
            appendTo.append('}');
        } else {
            appendTo.append('[');
            ObjectAppender.appendNullableJson(key, appendTo, appenderSupplier);
            appendTo.append(',');
            ObjectAppender.appendNullableJson(value, appendTo, appenderSupplier);
            appendTo.append(']');
        }
    }

    @Override
    public void append(Map<Object, Object> object, Appendable appendTo) throws IOException {
        appendTo.append(object.toString());
    }
}

