/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.csv;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.hash.THashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Arrays;
import org.spf4j.base.CharSequences;
import org.spf4j.io.PushbackReader;
import org.spf4j.io.csv.CsvHandler;
import org.spf4j.io.csv.CsvMapHandler;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.io.csv.CsvReader;
import org.spf4j.io.csv.CsvReader2Iterator;
import org.spf4j.io.csv.CsvRowHandler;
import org.spf4j.io.csv.CsvWriter;
import org.spf4j.io.csv.ElementAppendable;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
public final class CharSeparatedValues {
    public static final int UTF_BOM = 65279;
    private final char separator;
    private final char[] toEscape;

    public CharSeparatedValues(char separator) {
        if (separator == '\n' || separator == '\r' || separator == '\"') {
            throw new IllegalArgumentException("Illegal separator character " + separator);
        }
        this.separator = separator;
        this.toEscape = new char[]{separator, '\n', '\r', '\"'};
    }

    public CharSeparatedValues(char separator, char ... extraCharsToEscape) {
        if (separator == '\n' || separator == '\r' || separator == '\"') {
            throw new IllegalArgumentException("Illegal separator character " + separator);
        }
        this.separator = separator;
        this.toEscape = new char[4 + extraCharsToEscape.length];
        this.toEscape[0] = separator;
        this.toEscape[1] = 10;
        this.toEscape[2] = 13;
        this.toEscape[3] = 34;
        System.arraycopy(extraCharsToEscape, 0, this.toEscape, 4, extraCharsToEscape.length);
    }

    public void writeCsvRow(Appendable writer, Object ... elems) throws IOException {
        this.writeCsvRowNoEOL(writer, elems);
        writer.append('\n');
    }

    public void writeCsvRowNoEOL(Appendable writer, Object ... elems) throws IOException {
        if (elems.length > 0) {
            Object elem;
            int i = 0;
            if ((elem = elems[i++]) != null) {
                this.writeCsvElement(elem.toString(), writer);
            }
            while (i < elems.length) {
                writer.append(this.separator);
                if ((elem = elems[i++]) == null) continue;
                this.writeCsvElement(elem.toString(), writer);
            }
        }
    }

    public void writeCsvRow2(Appendable writer, Object obj, Object ... elems) throws IOException {
        if (obj != null) {
            this.writeCsvElement(obj.toString(), writer);
        }
        for (Object elem : elems) {
            writer.append(this.separator);
            if (elem == null) continue;
            this.writeCsvElement(elem.toString(), writer);
        }
        writer.append('\n');
    }

    public void writeCsvRow(Appendable writer, long ... elems) throws IOException {
        this.writeCsvRowNoEOL(elems, writer);
        writer.append('\n');
    }

    public void writeCsvRowNoEOL(long[] elems, Appendable writer) throws IOException {
        if (elems.length > 0) {
            int i = 0;
            writer.append(Long.toString(elems[i++]));
            while (i < elems.length) {
                writer.append(this.separator);
                writer.append(Long.toString(elems[i++]));
            }
        }
    }

    public void writeCsvRow(Appendable writer, Iterable<?> elems) throws IOException {
        this.writeCsvRowNoEOL(elems, writer);
        writer.append('\n');
    }

    public void writeCsvRowNoEOL(Iterable<?> elems, Appendable writer) throws IOException {
        Iterator<?> it = elems.iterator();
        if (it.hasNext()) {
            Object next = it.next();
            if (next != null) {
                this.writeCsvElement(next.toString(), writer);
            }
            while (it.hasNext()) {
                writer.append(this.separator);
                next = it.next();
                if (next == null) continue;
                this.writeCsvElement(next.toString(), writer);
            }
        }
    }

    public <T> T read(File file, Charset charset, CsvMapHandler<T> handler) throws IOException, CsvParseException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));){
            T t = this.read((Reader)br, handler);
            return t;
        }
    }

    public <T> T read(File file, Charset charset, CsvHandler<T> handler) throws IOException, CsvParseException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));){
            T t = this.read((Reader)br, handler);
            return t;
        }
    }

    public List<Map<String, String>> read(Reader preader) throws IOException, CsvParseException {
        return this.read(preader, new ToListMapHandler());
    }

    public <T> T read(Reader preader, CsvMapHandler<T> handler) throws IOException, CsvParseException {
        return this.read(preader, new CsvMapHandler2CsvHandler<T>(handler));
    }

    public List<String> readRow(Reader reader) throws IOException, CsvParseException {
        return this.readRow(reader, new CsvRow2List());
    }

    public <T> T readRow(Reader reader, CsvRowHandler<T> handler) throws IOException, CsvParseException {
        return this.read(reader, new OneRowHandler<T>(handler));
    }

    public <T> T read(Reader preader, CsvHandler<T> handler) throws IOException, CsvParseException {
        PushbackReader reader = new PushbackReader(preader);
        int firstChar = reader.read();
        if (firstChar != 65279 && firstChar >= 0) {
            reader.unread(firstChar);
        }
        return this.readNoBom(reader, handler);
    }

    public <T> T readNoBom(PushbackReader reader, CsvHandler<T> handler) throws IOException, CsvParseException {
        CsvReader r = this.reader(reader);
        handler.startRow(0L);
        CsvReader.TokenType token = r.next();
        while (token != CsvReader.TokenType.END_DOCUMENT) {
            if (token == CsvReader.TokenType.ELEMENT) {
                handler.element(r.getElement());
                token = r.next();
                continue;
            }
            if (token != CsvReader.TokenType.END_ROW) continue;
            handler.endRow();
            token = r.next();
            if (token != CsvReader.TokenType.ELEMENT) continue;
            handler.startRow(r.currentLineNumber());
        }
        return handler.eof();
    }

    public Iterable<Iterable<String>> asIterable(Reader preader) {
        return () -> {
            try {
                return new CsvReader2Iterator(this.reader(preader));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        };
    }

    public CsvReader reader(Reader preader) throws IOException {
        PushbackReader reader = new PushbackReader(preader);
        int firstChar = reader.read();
        if (firstChar != 65279 && firstChar >= 0) {
            reader.unread(firstChar);
        }
        return this.readerNoBOMILEL(reader);
    }

    @Deprecated
    public CsvReader readerILEL(Reader preader) throws IOException {
        return this.reader(preader);
    }

    public CsvReader readerNoBOM(PushbackReader reader) {
        return new CsvReaderImpl(reader);
    }

    @Deprecated
    public CsvReader readerNoBOMILEL(PushbackReader reader) {
        return new CsvReaderImpl(reader);
    }

    public CsvWriter writer(Writer writer) {
        return new CsvWriterImpl(writer);
    }

    public void writeCsvElement(CharSequence elem, Appendable writer) throws IOException {
        if (CharSequences.containsAnyChar(elem, this.toEscape)) {
            CharSeparatedValues.writeQuotedCsvElement(elem, writer);
        } else {
            writer.append(elem);
        }
    }

    public static void writeQuotedCsvElement(CharSequence elem, Appendable writer) throws IOException {
        writer.append('\"');
        CharSeparatedValues.writeQuotedElementContent(elem, 0, elem.length(), writer);
        writer.append('\"');
    }

    public static void writeQuotedElementContent(CharSequence elem, int start, int end, Appendable writer) throws IOException {
        for (int i = start; i < end; ++i) {
            char c = elem.charAt(i);
            CharSeparatedValues.writeQuotedChar(c, writer);
        }
    }

    public static void writeQuotedChar(char c, Appendable writer) throws IOException {
        if (c == '\"') {
            writer.append("\"\"");
        } else {
            writer.append(c);
        }
    }

    public CharSequence toCsvElement(CharSequence elem) {
        if (CharSequences.containsAnyChar(elem, this.toEscape)) {
            StringBuilder sw = new StringBuilder(elem.length() + 4);
            try {
                CharSeparatedValues.writeQuotedCsvElement(elem, sw);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return sw;
        }
        return elem;
    }

    public String toCsvElement(String elem) {
        if (CharSequences.containsAnyChar((CharSequence)elem, this.toEscape)) {
            StringBuilder sw = new StringBuilder(elem.length() + 4);
            try {
                CharSeparatedValues.writeQuotedCsvElement(elem, sw);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return sw.toString();
        }
        return elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckReturnValue
    public int readCsvElement(Reader reader, StringBuilder addElemTo, long lineNr) throws IOException, CsvParseException {
        int c = reader.read();
        if (c < 0) {
            return c;
        }
        if (c == 34) {
            c = reader.read();
            while (c >= 0) {
                if (c == 34) {
                    int c2 = reader.read();
                    if (c2 < 0) return c2;
                    if (c2 != 34) return c2;
                    addElemTo.append((char)c);
                } else {
                    addElemTo.append((char)c);
                }
                c = reader.read();
            }
            throw new CsvParseException("Escaped CSV element " + addElemTo + " not terminated correctly at " + lineNr);
        }
        while (c != this.separator && c != 10 && c != 13 && c >= 0) {
            addElemTo.append((char)c);
            c = reader.read();
        }
        return c;
    }

    public String toString() {
        return "CharSepValues{separator=" + this.separator + '}';
    }

    private class CsvWriterImpl
    implements CsvWriter {
        private final Writer writer;
        private boolean isStartLine = true;

        CsvWriterImpl(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void writeElement(CharSequence cs) throws IOException {
            this.addComma();
            CharSeparatedValues.this.writeCsvElement(cs, this.writer);
        }

        private void addComma() throws IOException {
            if (this.isStartLine) {
                this.isStartLine = false;
            } else {
                this.writer.append(CharSeparatedValues.this.separator);
            }
        }

        @Override
        public void writeEol() throws IOException {
            this.writer.append('\n');
            this.isStartLine = true;
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public ElementAppendable startQuotedElement() throws IOException {
            this.addComma();
            this.writer.write(34);
            return new ElementAppendable(){

                @Override
                public Appendable append(CharSequence csq) throws IOException {
                    CharSeparatedValues.writeQuotedElementContent(csq, 0, csq.length(), CsvWriterImpl.this.writer);
                    return this;
                }

                @Override
                public Appendable append(CharSequence csq, int start, int end) throws IOException {
                    CharSeparatedValues.writeQuotedElementContent(csq, start, end, CsvWriterImpl.this.writer);
                    return this;
                }

                @Override
                public Appendable append(char c) throws IOException {
                    CharSeparatedValues.writeQuotedChar(c, CsvWriterImpl.this.writer);
                    return this;
                }

                @Override
                public void close() throws IOException {
                    CsvWriterImpl.this.writer.write(34);
                }
            };
        }

        @Override
        public Appendable startRawElement() throws IOException {
            this.addComma();
            return new Appendable(){

                @Override
                public Appendable append(CharSequence csq) throws IOException {
                    if (CharSequences.containsAnyChar(csq, CharSeparatedValues.this.toEscape)) {
                        throw new IllegalStateException("Attempting to write str containing escapeable seq " + csq);
                    }
                    CsvWriterImpl.this.writer.append(csq);
                    return this;
                }

                @Override
                public Appendable append(CharSequence csq, int start, int end) throws IOException {
                    if (CharSequences.containsAnyChar(csq, start, end, CharSeparatedValues.this.toEscape)) {
                        throw new IllegalStateException("Attempting to write str containing escapeable seq " + csq);
                    }
                    CsvWriterImpl.this.writer.append(csq, start, end);
                    return this;
                }

                @Override
                public Appendable append(char c) throws IOException {
                    if (Arrays.search(CharSeparatedValues.this.toEscape, c) >= 0) {
                        throw new IllegalStateException("Attempting to write str containing escapeable seq " + c);
                    }
                    CsvWriterImpl.this.writer.append(c);
                    return this;
                }
            };
        }
    }

    private static final class CsvRow2List
    implements CsvRowHandler<List<String>> {
        private final List<String> result = new ArrayList<String>();

        private CsvRow2List() {
        }

        @Override
        public void element(CharSequence elem) {
            this.result.add(elem.toString());
        }

        @Override
        public List<String> eof() {
            return this.result;
        }
    }

    private static class OneRowHandler<T>
    implements CsvHandler<T> {
        private final CsvRowHandler<T> handler;

        OneRowHandler(CsvRowHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void startRow(long rowNr) {
            if (rowNr > 0L) {
                throw new IllegalArgumentException("Multiple rows encountered for " + this);
            }
        }

        @Override
        public void element(CharSequence elem) {
            this.handler.element(elem);
        }

        @Override
        public T eof() {
            return this.handler.eof();
        }
    }

    private class CsvReaderImpl
    implements CsvReader {
        private final PushbackReader reader;
        private final StringBuilder currentElement = new StringBuilder();
        private CsvReader.TokenType currentToken;
        private CsvReader.TokenType nextToken;
        private long lineNr = 0L;

        CsvReaderImpl(PushbackReader reader) {
            this.reader = reader;
            this.currentToken = CsvReader.TokenType.START_DOCUMENT;
            this.nextToken = null;
        }

        @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
        private void readNext() throws IOException, CsvParseException {
            switch (this.currentToken) {
                case END_DOCUMENT: {
                    this.nextToken = CsvReader.TokenType.END_DOCUMENT;
                    return;
                }
                case END_ROW: {
                    int peek = this.reader.read();
                    if (peek < 0) {
                        this.currentToken = CsvReader.TokenType.END_DOCUMENT;
                        this.nextToken = CsvReader.TokenType.END_DOCUMENT;
                        return;
                    }
                    this.reader.unread(peek);
                }
                case START_DOCUMENT: 
                case ELEMENT: {
                    this.currentElement.setLength(0);
                    int next = CharSeparatedValues.this.readCsvElement(this.reader, this.currentElement, this.lineNr);
                    this.currentToken = CsvReader.TokenType.ELEMENT;
                    switch (next) {
                        case 13: {
                            ++this.lineNr;
                            this.nextToken = CsvReader.TokenType.END_ROW;
                            int c2 = this.reader.read();
                            if (c2 < 0) {
                                return;
                            }
                            if (c2 != 10) {
                                this.reader.unread(c2);
                            }
                            return;
                        }
                        case 10: {
                            ++this.lineNr;
                            this.nextToken = CsvReader.TokenType.END_ROW;
                            int c2 = this.reader.read();
                            if (c2 < 0) {
                                return;
                            }
                            if (c2 == 13) break;
                            this.reader.unread(c2);
                            break;
                        }
                        default: {
                            if (next == CharSeparatedValues.this.separator) break;
                            if (next < 0) {
                                this.nextToken = CsvReader.TokenType.END_ROW;
                                break;
                            }
                            throw new CsvParseException("Unexpected character " + next + " at line" + this.lineNr);
                        }
                    }
                    return;
                }
            }
            throw new IllegalStateException("Invalid current token " + (Object)((Object)this.currentToken));
        }

        @Override
        public CsvReader.TokenType next() throws IOException, CsvParseException {
            if (this.nextToken == null) {
                this.readNext();
                return this.currentToken;
            }
            CsvReader.TokenType result = this.nextToken;
            if (result != CsvReader.TokenType.END_DOCUMENT) {
                this.nextToken = null;
            }
            this.currentToken = result;
            return result;
        }

        @Override
        public CsvReader.TokenType current() {
            return this.currentToken;
        }

        @Override
        public CharSequence getElement() {
            if (this.currentToken != CsvReader.TokenType.ELEMENT) {
                throw new IllegalStateException("No current element, current token is " + (Object)((Object)this.currentToken));
            }
            return this.currentElement;
        }

        @Override
        public long currentLineNumber() {
            return this.lineNr;
        }
    }

    private static class CsvMapHandler2CsvHandler<T>
    implements CsvHandler<T> {
        private final CsvMapHandler<T> handler;
        private boolean first = true;
        private final List<String> header = new ArrayList<String>();
        private int elemIdx;
        private Map<String, String> row = null;
        private long lineNr;

        CsvMapHandler2CsvHandler(CsvMapHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void startRow(long ln) {
            this.lineNr = ln;
            this.elemIdx = 0;
            if (!this.first) {
                this.row = new THashMap(this.header.size());
            }
        }

        @Override
        public void element(CharSequence elem) throws CsvParseException {
            if (this.first) {
                this.header.add(elem.toString());
            } else {
                if (this.header.size() <= this.elemIdx) {
                    throw new CsvParseException("Too many elements in row " + this.row + " at line " + this.lineNr);
                }
                this.row.put(this.header.get(this.elemIdx), elem.toString());
            }
            ++this.elemIdx;
        }

        @Override
        public void endRow() {
            if (this.first) {
                this.first = false;
            } else {
                this.handler.row(this.row);
            }
        }

        @Override
        public T eof() {
            return this.handler.eof();
        }
    }

    private static class ToListMapHandler
    implements CsvMapHandler<List<Map<String, String>>> {
        private List<Map<String, String>> result = new ArrayList<Map<String, String>>();

        private ToListMapHandler() {
        }

        @Override
        public void row(Map<String, String> row) {
            this.result.add(row);
        }

        @Override
        public List<Map<String, String>> eof() {
            return this.result;
        }
    }
}

