/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.csv;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.io.csv.IterableCsvReader;

public interface CsvReader {
    @Nonnull
    public TokenType next() throws IOException, CsvParseException;

    @Nonnull
    public TokenType current();

    public CharSequence getElement();

    public long currentLineNumber();

    default public int skipRow() throws IOException, CsvParseException {
        int skipped = 0;
        TokenType current = this.current();
        if (current == TokenType.START_DOCUMENT) {
            this.next();
        }
        while ((current = this.current()) != TokenType.END_ROW && current != TokenType.END_DOCUMENT) {
            this.next();
            ++skipped;
        }
        if (current != TokenType.END_DOCUMENT) {
            this.next();
        }
        return skipped;
    }

    default public void readRow(Consumer<CharSequence> consumer) throws IOException, CsvParseException {
        TokenType current = this.current();
        if (current == TokenType.START_DOCUMENT) {
            this.next();
        }
        while ((current = this.current()) != TokenType.END_ROW && current != TokenType.END_DOCUMENT) {
            consumer.accept(this.getElement());
            this.next();
        }
        if (current != TokenType.END_DOCUMENT) {
            this.next();
        }
    }

    public static CsvReader toReader(Iterator<? extends CharSequence> it) {
        return new IterableCsvReader(it);
    }

    public static enum TokenType {
        START_DOCUMENT,
        ELEMENT,
        END_ROW,
        END_DOCUMENT;

    }
}

