/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.csv;

import java.io.EOFException;
import java.util.Iterator;
import org.spf4j.io.csv.CsvReader;

class IterableCsvReader
implements CsvReader {
    private CsvReader.TokenType currentToken;
    private CharSequence current;
    private final Iterator<? extends CharSequence> it;
    private boolean finished;

    IterableCsvReader(Iterator<? extends CharSequence> it) {
        this.it = it;
        this.current = null;
        this.finished = false;
        this.currentToken = CsvReader.TokenType.START_DOCUMENT;
    }

    @Override
    public CsvReader.TokenType next() throws EOFException {
        if (this.finished) {
            this.currentToken = CsvReader.TokenType.END_DOCUMENT;
            return this.currentToken;
        }
        if (this.it.hasNext()) {
            this.current = this.it.next();
            this.currentToken = CsvReader.TokenType.ELEMENT;
        } else {
            this.finished = true;
            this.currentToken = CsvReader.TokenType.END_ROW;
        }
        return this.currentToken;
    }

    @Override
    public CsvReader.TokenType current() {
        return this.currentToken;
    }

    @Override
    public CharSequence getElement() {
        if (this.currentToken != CsvReader.TokenType.ELEMENT) {
            throw new IllegalStateException("Not at a element " + (Object)((Object)this.currentToken));
        }
        return this.current;
    }

    public String toString() {
        return "IterableCsvReader{current=" + this.current + ", it=" + this.it + ", finished=" + this.finished + '}';
    }

    @Override
    public long currentLineNumber() {
        return 0L;
    }
}

