/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.tcp.proxy;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.io.tcp.proxy.Sniffer;

public final class TransferBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(TransferBuffer.class);
    private final ByteBuffer buffer;
    private Operation lastOperation;
    private boolean isEof;
    private Runnable isDataInBufferHook;
    private Runnable isRoomInBufferHook;
    private Sniffer incomingSniffer;
    private IOException readException;
    private IOException writeException;

    public TransferBuffer(int bufferSize) {
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.lastOperation = Operation.READ;
        this.isEof = false;
        this.isDataInBufferHook = null;
        this.isRoomInBufferHook = null;
        this.readException = null;
        this.writeException = null;
    }

    public synchronized int read(SocketChannel channel) {
        int nrRead;
        IOException oex;
        block15: {
            if (this.lastOperation == Operation.WRITE) {
                this.buffer.compact();
                this.lastOperation = Operation.READ;
            }
            oex = null;
            try {
                nrRead = channel.read(this.buffer);
                if (this.incomingSniffer != null && nrRead != 0) {
                    nrRead = this.incomingSniffer.received(this.buffer, nrRead);
                }
            }
            catch (IOException ex) {
                oex = ex;
                this.readException = this.incomingSniffer == null ? ex : this.incomingSniffer.received(ex);
                if (this.readException != null) {
                    LOG.debug("Exception while reading from {}", (Object)channel, (Object)ex);
                    nrRead = -1;
                } else {
                    nrRead = 0;
                }
                try {
                    channel.close();
                }
                catch (IOException ex1) {
                    if (this.readException == null) break block15;
                    this.readException.addSuppressed(ex1);
                }
            }
        }
        if (nrRead < 0) {
            this.isEof = true;
            try {
                channel.socket().shutdownInput();
            }
            catch (ClosedChannelException ex) {
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        } else if (oex == null && this.buffer.hasRemaining()) {
            this.isRoomInBufferHook.run();
        }
        if (this.buffer.position() > 0 || this.isEof) {
            this.isDataInBufferHook.run();
        }
        return nrRead;
    }

    public synchronized int write(SocketChannel channel) {
        int nrWritten;
        if (this.lastOperation == Operation.READ) {
            this.buffer.flip();
            this.lastOperation = Operation.WRITE;
        }
        try {
            nrWritten = channel.write(this.buffer);
        }
        catch (IOException ex) {
            try {
                channel.close();
            }
            catch (IOException ex1) {
                ex.addSuppressed(ex1);
            }
            LOG.debug("Exception while writing to {}", (Object)channel, (Object)ex);
            this.writeException = ex;
            nrWritten = 0;
        }
        boolean hasRemaining = this.buffer.hasRemaining();
        if (!hasRemaining) {
            if (this.isEof) {
                try {
                    channel.socket().shutdownOutput();
                }
                catch (ClosedChannelException ex1) {
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                return nrWritten;
            }
            if (this.readException != null) {
                try {
                    channel.socket().shutdownOutput();
                }
                catch (ClosedChannelException ex) {
                }
                catch (IOException ex) {
                    this.readException.addSuppressed(ex);
                }
                LOG.debug("Closed channel {} due to read exception", (Object)channel, (Object)this.readException);
                return nrWritten;
            }
        }
        if (!this.isEof && this.buffer.position() > 0) {
            this.isRoomInBufferHook.run();
        }
        if (hasRemaining && this.writeException != null) {
            this.isDataInBufferHook.run();
        }
        return nrWritten;
    }

    public static int transfer(SocketChannel in, SocketChannel out, ByteBuffer buffer) throws IOException {
        int read = 0;
        while (in.finishConnect() && (read = in.read(buffer)) > 0 || buffer.position() > 0) {
            buffer.flip();
            if (!out.finishConnect()) break;
            int writen = out.write(buffer);
            buffer.compact();
            if (writen > 0) continue;
            break;
        }
        return read;
    }

    public synchronized void setIsDataInBufferHook(Runnable isDataInBufferHook) {
        this.isDataInBufferHook = isDataInBufferHook;
    }

    public synchronized void setIsRoomInBufferHook(Runnable isRoomInBufferHook) {
        this.isRoomInBufferHook = isRoomInBufferHook;
    }

    public synchronized void setIncomingSniffer(Sniffer incomingSniffer) {
        this.incomingSniffer = incomingSniffer;
    }

    public String toString() {
        return "TransferBuffer{buffer=" + this.buffer + ", lastOperation=" + (Object)((Object)this.lastOperation) + ", isEof=" + this.isEof + ", isDataInBufferHook=" + this.isDataInBufferHook + ", isRoomInBufferHook=" + this.isRoomInBufferHook + '}';
    }

    public static enum Operation {
        READ,
        WRITE;

    }
}

