/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.concurrent.Semaphore;
import org.spf4j.jdbc.DataSourceEx;
import org.spf4j.jdbc.SemaphoredConnectionInvocationHandler;

class DataSourceExImpl
implements DataSourceEx {
    private final DataSource ds;
    private final Semaphore sem;

    DataSourceExImpl(Semaphore sem, DataSource ds) {
        this.ds = ds;
        this.sem = sem;
    }

    @Override
    public Connection getConnection(long timeout, TimeUnit unit) throws SQLException {
        boolean tryAcquire;
        try {
            tryAcquire = this.sem.tryAcquire(1, timeout, unit);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new SQLException(ex);
        }
        if (!tryAcquire) {
            throw new SQLTimeoutException();
        }
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new SemaphoredConnectionInvocationHandler(this.ds.getConnection(), this.sem));
    }

    @Override
    public Connection getConnection() throws SQLException {
        boolean tryAcquire;
        try {
            tryAcquire = this.sem.tryAcquire(1, ExecutionContexts.getContextDeadlineNanos());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new SQLException(ex);
        }
        if (!tryAcquire) {
            throw new SQLTimeoutException();
        }
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new SemaphoredConnectionInvocationHandler(this.ds.getConnection(), this.sem));
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.ds.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.ds.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.ds.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.ds.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ds.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ds.isWrapperFor(iface);
    }

    public String toString() {
        return "DataSourceExImpl{ds=" + this.ds + ", sem=" + this.sem + '}';
    }
}

