/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdbc;

public enum DbType {
    ORACLE,
    H2,
    SYBASE_ASE,
    SYBASE_IQ,
    MSSQL,
    MYSQL,
    POSTGRES,
    COCKROACH_DB;

    public static final DbType DEFAULT;

    public static String getCurrTSSqlFn(DbType dbType) throws ExceptionInInitializerError {
        switch (dbType) {
            case H2: {
                return "TIMESTAMPDIFF('MILLISECOND', timestamp '1970-01-01 00:00:00', CURRENT_TIMESTAMP())";
            }
            case ORACLE: {
                return "(SYSDATE - TO_DATE('01-01-1970 00:00:00', 'DD-MM-YYYY HH24:MI:SS')) * 24 * 3600000";
            }
            case MSSQL: {
                return "DATEDIFF(ms, '1970-01-01 00:00:00', GETUTCDATE())";
            }
            case POSTGRES: {
                return "extract(epoch FROM now()) * 1000";
            }
            case COCKROACH_DB: {
                return "extract(epoch_nanosecond from now()) / 1e6";
            }
        }
        throw new IllegalArgumentException("Database not supported " + (Object)((Object)dbType));
    }

    public String getCurrTSSqlFn() throws ExceptionInInitializerError {
        return DbType.getCurrTSSqlFn(this);
    }

    static {
        DEFAULT = DbType.valueOf(System.getProperty("spf4j.jdbc.defaultDbType", "H2"));
    }
}

