/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.spf4j.concurrent.Semaphore;

final class SemaphoredConnectionInvocationHandler
implements InvocationHandler {
    private final Connection raw;
    private final Semaphore sem;
    private boolean closed;

    SemaphoredConnectionInvocationHandler(Connection raw, Semaphore sem) {
        this.raw = raw;
        this.sem = sem;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        String mName = method.getName();
        if ("close".equals(mName)) {
            if (!this.closed) {
                this.sem.release();
                this.closed = true;
            }
            return null;
        }
        return method.invoke((Object)this.raw, args);
    }

    public String toString() {
        return "SemaphoredConnectionInvocationHandler{raw=" + this.raw + ", sem=" + this.sem + ", closed=" + this.closed + '}';
    }
}

