/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.NotSerializableException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.management.ObjectName;
import org.spf4j.base.Reflections;
import org.spf4j.base.Strings;
import org.spf4j.jmx.BeanExportedValue;
import org.spf4j.jmx.ExportedOperation;
import org.spf4j.jmx.ExportedOperationImpl;
import org.spf4j.jmx.ExportedValue;
import org.spf4j.jmx.ExportedValuesMBean;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.MapExportedValue;
import org.spf4j.jmx.Registry;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class DynamicMBeanBuilder {
    private final Map<String, ExportedValue<?>> exportedAttributes = new HashMap(8);
    private final Map<String, ExportedOperation> exportedOps = new HashMap<String, ExportedOperation>(4);

    public static DynamicMBeanBuilder newBuilder() {
        return new DynamicMBeanBuilder();
    }

    public DynamicMBeanBuilder withOperation(ExportedOperation operation) {
        if (this.exportedOps.put(operation.getName(), operation) != null) {
            throw new IllegalArgumentException("Duplicate operation: " + operation);
        }
        return this;
    }

    public DynamicMBeanBuilder withAttribute(ExportedValue<?> val) {
        if (this.exportedAttributes.put(val.getName(), val) != null) {
            throw new IllegalArgumentException("Duplicate attribute: " + val);
        }
        return this;
    }

    public DynamicMBeanBuilder withAttributes(ExportedValue<?> ... vals) {
        for (ExportedValue<?> ev : vals) {
            this.withAttribute(ev);
        }
        return this;
    }

    public DynamicMBeanBuilder withAttributes(Map<String, Object> mapAttributes) {
        for (Map.Entry<String, Object> entry : mapAttributes.entrySet()) {
            String key = entry.getKey();
            if (key == null || key.isEmpty()) continue;
            try {
                if (this.exportedAttributes.put(key, new MapExportedValue(mapAttributes, null, key, entry.getValue())) == null) continue;
                throw new IllegalArgumentException("Duplicate attribute: " + key);
            }
            catch (NotSerializableException ex) {
                throw new IllegalArgumentException("Unable to export map entry via JMX: " + entry, ex);
            }
        }
        return this;
    }

    public DynamicMBeanBuilder withJmxExportObject(Object object) {
        HashMap attrs = new HashMap(4);
        if (object instanceof Class) {
            for (Method method : ((Class)object).getMethods()) {
                JmxExport annot;
                if (method.isSynthetic() || !Modifier.isStatic(method.getModifiers()) || (annot = method.getAnnotation(JmxExport.class)) == null) continue;
                DynamicMBeanBuilder.exportMethod(method, null, attrs, this.exportedOps, annot);
            }
        } else {
            Class<?> oClass = object.getClass();
            for (Method method : oClass.getMethods()) {
                JmxExport annot;
                if (method.isSynthetic() || (annot = method.getAnnotation(JmxExport.class)) == null) continue;
                DynamicMBeanBuilder.exportMethod(method, object, attrs, this.exportedOps, annot);
            }
        }
        Collection values = attrs.values();
        for (ExportedValue expVal : values) {
            if (((BeanExportedValue)expVal).isValid()) continue;
            throw new IllegalArgumentException("If setter is exported, getter must be exported as well " + expVal);
        }
        this.exportedAttributes.putAll(attrs);
        return this;
    }

    public DynamicMBeanBuilder withJmxExportObjects(Object ... objects) {
        for (Object object : objects) {
            this.withJmxExportObject(object);
        }
        return this;
    }

    @Nullable
    public ExportedValuesMBean build(String packageName, String mbeanName) {
        if (this.exportedAttributes.isEmpty() && this.exportedOps.isEmpty()) {
            return null;
        }
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        return new ExportedValuesMBean(objectName, this.exportedAttributes, this.exportedOps);
    }

    @Nonnull
    public ExportedValuesMBean extend(@Nonnull ExportedValuesMBean toExtend) {
        if (this.exportedAttributes.isEmpty() && this.exportedOps.isEmpty()) {
            return toExtend;
        }
        return new ExportedValuesMBean(toExtend, this.exportedAttributes, this.exportedOps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExportedValuesMBean extend(String packageName, String mbeanName) {
        if (this.exportedAttributes.isEmpty() && this.exportedOps.isEmpty()) {
            return null;
        }
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            ExportedValuesMBean existing = (ExportedValuesMBean)Registry.unregister(objectName);
            ExportedValuesMBean mbean = existing == null ? new ExportedValuesMBean(objectName, this.exportedAttributes, this.exportedOps) : new ExportedValuesMBean(existing, this.exportedAttributes, this.exportedOps);
            Registry.registerMBean(objectName, mbean);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return mbean;
        }
    }

    public boolean isEmpty() {
        return this.exportedAttributes.isEmpty() && this.exportedOps.isEmpty();
    }

    @Nonnull
    public ExportedValuesMBean replace(String packageName, String mbeanName) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Nothing to register " + this);
        }
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        ExportedValuesMBean mbean = new ExportedValuesMBean(objectName, this.exportedAttributes, this.exportedOps);
        Registry.registerMBean(objectName, mbean);
        return mbean;
    }

    @Nullable
    public ExportedValuesMBean replaceIfExports(String packageName, String mbeanName) {
        if (this.isEmpty()) {
            return null;
        }
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        ExportedValuesMBean mbean = new ExportedValuesMBean(objectName, this.exportedAttributes, this.exportedOps);
        Registry.registerMBean(objectName, mbean);
        return mbean;
    }

    @Nonnull
    public ExportedValuesMBean register(String packageName, String mbeanName) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Nothing to register " + this);
        }
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        ExportedValuesMBean mbean = new ExportedValuesMBean(objectName, this.exportedAttributes, this.exportedOps);
        Registry.registerIfNotExistsMBean(objectName, mbean);
        return mbean;
    }

    @Nullable
    public ExportedValuesMBean registerIfExports(String packageName, String mbeanName) {
        if (this.isEmpty()) {
            return null;
        }
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        ExportedValuesMBean mbean = new ExportedValuesMBean(objectName, this.exportedAttributes, this.exportedOps);
        Registry.registerIfNotExistsMBean(objectName, mbean);
        return mbean;
    }

    static void exportMethod(Method method, @Nullable Object object, Map<String, ExportedValue<?>> exportedAttributes, Map<String, ExportedOperation> exportedOps, JmxExport annot) {
        AccessController.doPrivileged(() -> {
            method.setAccessible(true);
            return null;
        });
        String methodName = method.getName();
        int nrParams = method.getParameterCount();
        if (nrParams == 0 && methodName.startsWith("get")) {
            String valueName = methodName.substring("get".length());
            valueName = Strings.withFirstCharLower(valueName);
            DynamicMBeanBuilder.addGetter(valueName, exportedAttributes, annot, method, object);
        } else if (nrParams == 0 && methodName.startsWith("is")) {
            String valueName = methodName.substring("is".length());
            valueName = Strings.withFirstCharLower(valueName);
            DynamicMBeanBuilder.addGetter(valueName, exportedAttributes, annot, method, object);
        } else if (nrParams == 1 && methodName.startsWith("set")) {
            DynamicMBeanBuilder.addSetter(methodName, exportedAttributes, method, object, annot);
        } else {
            ExportedOperation existing;
            String opName = methodName;
            String nameOverwrite = annot.value();
            if (!"".equals(nameOverwrite)) {
                opName = nameOverwrite;
            }
            if ((existing = exportedOps.put(opName, new ExportedOperationImpl(opName, annot.description(), method, object, annot.mapOpenType()))) != null) {
                throw new IllegalArgumentException("exporting operations with same name not supported: " + opName);
            }
        }
    }

    private static void addSetter(String methodName, Map<String, ExportedValue<?>> exportedAttributes, Method method, Object object, JmxExport annot) {
        String valueName;
        String customName = annot.value();
        if ("".equals(customName)) {
            valueName = methodName.substring("set".length());
            valueName = Strings.withFirstCharLower(valueName);
        } else {
            valueName = customName;
        }
        BeanExportedValue existing = (BeanExportedValue)exportedAttributes.get(valueName);
        Class<?> parameterType = Reflections.getParameterTypes(method)[0];
        if (existing == null) {
            existing = new BeanExportedValue(valueName, null, null, method, object, parameterType, annot.mapOpenType());
        } else {
            if (existing.getValueType() != parameterType) {
                throw new IllegalArgumentException("Getter and setter icorrectly defined " + existing + ' ' + method);
            }
            existing = existing.withSetter(method);
        }
        exportedAttributes.put(valueName, existing);
    }

    private static void addGetter(String pvalueName, Map<String, ExportedValue<?>> exported, JmxExport annot, Method method, Object object) {
        String customName = annot.value();
        String valueName = "".equals(customName) ? pvalueName : customName;
        BeanExportedValue existing = (BeanExportedValue)exported.get(valueName);
        if (existing == null) {
            existing = new BeanExportedValue(valueName, annot.description(), method, null, object, method.getGenericReturnType(), annot.mapOpenType());
        } else {
            if (existing.getValueType() != method.getReturnType()) {
                throw new IllegalArgumentException("Getter and setter icorrectly defined " + existing + ' ' + method);
            }
            existing = existing.withGetter(method, annot.description());
        }
        exported.put(valueName, existing);
    }

    public String toString() {
        return "MBeanBuilder{exportedAttributes=" + this.exportedAttributes + ", exportedOps=" + this.exportedOps + '}';
    }
}

