/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import org.spf4j.jmx.ExportedOperation;
import org.spf4j.jmx.GlobalMXBeanMapperSupplier;
import org.spf4j.jmx.JMXBeanMapping;
import org.spf4j.jmx.JmxExport;

final class ExportedOperationImpl
implements ExportedOperation {
    private final String name;
    private final String description;
    private final Method method;
    private final Object object;
    private final MBeanParameterInfo[] paramInfos;
    private final JMXBeanMapping[] argConverters;
    private final JMXBeanMapping resultConverter;

    ExportedOperationImpl(String name, String description, Method method, Object object, boolean mapOpenType) {
        this.name = name;
        this.description = description;
        this.method = method;
        this.object = object;
        Type[] parameterTypes = method.getGenericParameterTypes();
        Type returnType = method.getGenericReturnType();
        if (mapOpenType) {
            try {
                this.resultConverter = GlobalMXBeanMapperSupplier.getOpenTypeMapping(returnType);
            }
            catch (NotSerializableException ex) {
                throw new UnsupportedOperationException("Cannot export " + method + " returned type not serializable", ex);
            }
        } else {
            this.resultConverter = null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        this.argConverters = new JMXBeanMapping[parameterTypes.length];
        this.paramInfos = new MBeanParameterInfo[parameterTypes.length];
        for (int i = 0; i < this.paramInfos.length; ++i) {
            JMXBeanMapping paramOTM;
            Annotation[] annotations = parameterAnnotations[i];
            String pname = "";
            String pdesc = "";
            boolean mapParamOpenType = mapOpenType;
            for (Annotation annot : annotations) {
                if (annot.annotationType() != JmxExport.class) continue;
                JmxExport eAnn = (JmxExport)annot;
                pname = eAnn.value();
                pdesc = eAnn.description();
                mapParamOpenType = eAnn.mapOpenType();
                break;
            }
            if ("".equals(pname)) {
                pname = "param_" + i;
            }
            if (pdesc.isEmpty()) {
                pdesc = pname;
            }
            Type parameterType = parameterTypes[i];
            if (mapParamOpenType) {
                try {
                    paramOTM = GlobalMXBeanMapperSupplier.getOpenTypeMapping(parameterType);
                }
                catch (NotSerializableException ex) {
                    throw new UnsupportedOperationException("Cannot export " + method + " arg " + i + " not serializable", ex);
                }
            } else {
                paramOTM = null;
            }
            if (paramOTM != null) {
                this.paramInfos[i] = new OpenMBeanParameterInfoSupport(pname, pdesc, paramOTM.getOpenType());
                this.argConverters[i] = paramOTM;
                continue;
            }
            this.paramInfos[i] = new MBeanParameterInfo(pname, parameterType.getTypeName(), pdesc);
            this.argConverters[i] = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object invoke(Object[] parameters) throws ReflectionException, OpenDataException, InvalidObjectException {
        try {
            for (int i = 0; i < parameters.length; ++i) {
                JMXBeanMapping argConverter = this.argConverters[i];
                if (argConverter == null) continue;
                parameters[i] = argConverter.fromOpenValue(parameters[i]);
            }
            Object rVal = this.method.invoke(this.object, parameters);
            if (this.resultConverter != null) {
                return this.resultConverter.toOpenValue(rVal);
            }
            return rVal;
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex, "Failure invoking " + this.method + " with " + Arrays.toString(parameters));
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof Exception) {
                throw new ReflectionException((Exception)cause, "Failure invoking " + this.method + " with " + Arrays.toString(parameters));
            }
            throw new ReflectionException(new RuntimeException(ex), "Failure invoking " + this.method + " with " + Arrays.toString(parameters));
        }
    }

    @Override
    public MBeanParameterInfo[] getParameterInfos() {
        return this.paramInfos;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public String toString() {
        return "ExportedOperationImpl{name=" + this.name + ", description=" + this.description + ", method=" + this.method + ", object=" + this.object + ", paramInfos=" + Arrays.toString(this.paramInfos) + '}';
    }

    @Override
    @Nullable
    public OpenType<?> getReturnOpenType() {
        return this.resultConverter != null ? this.resultConverter.getOpenType() : null;
    }
}

