/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import java.io.InvalidObjectException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import org.spf4j.base.Reflections;

public interface ExportedValue<T> {
    public String getName();

    public String getDescription();

    public T get() throws MBeanException, ReflectionException, OpenDataException;

    public void set(T var1) throws AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException, InvalidObjectException;

    public boolean isWriteable();

    public Type getValueType();

    @Nullable
    public OpenType<?> getValueOpenType();

    default public MBeanAttributeInfo toAttributeInfo() {
        Type oClass = this.getValueType();
        Class<?> valClass = oClass instanceof Class ? Reflections.primitiveToWrapper((Class)oClass) : null;
        OpenType<?> openType = this.getValueOpenType();
        String description = this.getDescription();
        if (description == null || description.isEmpty()) {
            description = this.getName();
        }
        if (openType != null) {
            try {
                return new OpenMBeanAttributeInfoSupport(this.getName(), description, openType, true, this.isWriteable(), valClass == Boolean.class);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Cannot export " + this, ex);
            }
        }
        return new MBeanAttributeInfo(this.getName(), oClass.getTypeName(), this.getDescription(), true, this.isWriteable(), valClass == Boolean.class);
    }
}

