/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.spf4j.jmx.ExportedOperation;
import org.spf4j.jmx.ExportedValue;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
final class ExportedValuesMBean
implements DynamicMBean {
    private static final Pattern INVALID_CHARS = Pattern.compile("[^a-zA-Z0-9_\\-\\.]");
    private final Map<String, ExportedValue<?>> exportedValues;
    private final Map<String, ExportedOperation> exportedOperations;
    private final ObjectName objectName;
    private final MBeanInfo beanInfo;

    ExportedValuesMBean(ObjectName objectName, Map<String, ExportedValue<?>> exportedValues, Map<String, ExportedOperation> exportedOperations) {
        this.exportedOperations = exportedOperations;
        this.exportedValues = exportedValues;
        this.objectName = objectName;
        this.beanInfo = this.createBeanInfo();
    }

    ExportedValuesMBean(ObjectName objectName, ExportedValue<?>[] exported, ExportedOperation[] operations) {
        this.exportedValues = new HashMap(exported.length);
        for (ExportedValue<?> val : exported) {
            if (this.exportedValues.put(val.getName(), val) == null) continue;
            throw new IllegalArgumentException("Duplicate attribute " + val);
        }
        this.exportedOperations = new HashMap<String, ExportedOperation>(operations.length);
        for (ExportedOperation op : operations) {
            if (this.exportedOperations.put(op.getName(), op) == null) continue;
            throw new IllegalArgumentException("Duplicate operation " + op);
        }
        this.objectName = objectName;
        this.beanInfo = this.createBeanInfo();
    }

    ExportedValuesMBean(ExportedValuesMBean extend, ExportedValue<?>[] exported, ExportedOperation[] operations) {
        this.exportedValues = new HashMap(exported.length + extend.exportedValues.size());
        this.exportedValues.putAll(extend.exportedValues);
        for (ExportedValue<?> val : exported) {
            if (this.exportedValues.put(val.getName(), val) == null) continue;
            throw new IllegalArgumentException("Duplicate attribute " + val);
        }
        this.exportedOperations = new HashMap<String, ExportedOperation>(operations.length + extend.exportedOperations.size());
        this.exportedOperations.putAll(extend.exportedOperations);
        for (ExportedOperation op : operations) {
            if (this.exportedOperations.put(op.getName(), op) == null) continue;
            throw new IllegalArgumentException("Duplicate operation " + op);
        }
        this.objectName = extend.getObjectName();
        this.beanInfo = extend.beanInfo;
    }

    ExportedValuesMBean(ExportedValuesMBean extend, Map<String, ExportedValue<?>> exportedValues, Map<String, ExportedOperation> exportedOperations) {
        this.exportedValues = exportedValues;
        this.exportedValues.putAll(extend.exportedValues);
        this.exportedOperations = exportedOperations;
        this.exportedOperations.putAll(extend.exportedOperations);
        this.objectName = extend.getObjectName();
        this.beanInfo = this.createBeanInfo();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ExportedValue<?> result = this.exportedValues.get(name);
        if (result == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            return result.get();
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (RuntimeException | OpenDataException ex) {
            Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.SEVERE, "Exception while getting attr {0}", name);
            Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.SEVERE, "Exception detail", ex);
            throw new MBeanException(ex, "Error getting attribute" + name);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attribute.getName();
        ExportedValue<?> result = this.exportedValues.get(name);
        if (result == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            result.set(attribute.getValue());
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (InvalidObjectException | RuntimeException ex) {
            Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.SEVERE, "Exception while setting attr {0}", attribute);
            Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.SEVERE, "Exception detail", ex);
            InvalidAttributeValueException jx = new InvalidAttributeValueException("Invalid value " + attribute);
            jx.addSuppressed(ex);
            throw jx;
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList list = new AttributeList(names.length);
        for (String name : names) {
            try {
                ExportedValue<?> attr = this.exportedValues.get(name);
                if (attr == null) {
                    throw new IllegalArgumentException("No attribute with name " + name);
                }
                list.add(new Attribute(name, attr.get()));
            }
            catch (RuntimeException | MBeanException | ReflectionException | OpenDataException ex) {
                Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.SEVERE, "Exception getting attribute {0}", name);
                Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.SEVERE, "Exception detail", ex);
                JMRuntimeException jx = new JMRuntimeException("Exception while getting attributes " + Arrays.toString(names));
                jx.addSuppressed(ex);
                throw jx;
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        AttributeList result = new AttributeList(list.size());
        for (Attribute attr : list.asList()) {
            ExportedValue<?> eval = this.exportedValues.get(attr.getName());
            if (eval == null) continue;
            try {
                eval.set(attr.getValue());
                result.add(attr);
            }
            catch (InvalidObjectException | RuntimeException | AttributeNotFoundException | InvalidAttributeValueException | MBeanException | ReflectionException ex) {
                Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.WARNING, "Exception while setting attr {}", attr);
                Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.WARNING, "Exception detail", ex);
                JMRuntimeException jx = new JMRuntimeException("Exception while setting attributes " + list);
                jx.addSuppressed(ex);
                throw jx;
            }
        }
        return result;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        try {
            return this.exportedOperations.get(name).invoke(args);
        }
        catch (InvalidObjectException | RuntimeException | OpenDataException ex) {
            Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.WARNING, "Exception while invoking operation {0}({1})", new Object[]{name, args});
            Logger.getLogger(ExportedValuesMBean.class.getName()).log(Level.WARNING, "Exception detail", ex);
            throw new MBeanException(ex, "Exception invoking " + name + " with " + Arrays.toString(args));
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    public static ObjectName createObjectName(String domain, String name) {
        try {
            String sanitizedDomain = INVALID_CHARS.matcher(domain).replaceAll("_");
            String sanitizedName = INVALID_CHARS.matcher(name).replaceAll("_");
            StringBuilder builder = new StringBuilder(domain.length() + name.length() + 6);
            builder.append(sanitizedDomain).append(':');
            builder.append("name=").append(sanitizedName);
            return new ObjectName(builder.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid name for " + domain + ", " + name, e);
        }
    }

    private MBeanInfo createBeanInfo() {
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[this.exportedValues.size()];
        int i = 0;
        for (ExportedValue<?> val : this.exportedValues.values()) {
            attrs[i++] = val.toAttributeInfo();
        }
        MBeanOperationInfo[] operations = new MBeanOperationInfo[this.exportedOperations.size()];
        i = 0;
        for (ExportedOperation op : this.exportedOperations.values()) {
            MBeanParameterInfo[] paramInfos = op.getParameterInfos();
            String description = op.getDescription();
            if (description == null || description.isEmpty()) {
                description = op.getName();
            }
            OpenType<?> openType = op.getReturnOpenType();
            operations[i++] = new MBeanOperationInfo(op.getName(), description, paramInfos, op.getReturnType().getName(), 0, openType == null ? null : new ImmutableDescriptor(new String[]{"openType", "originalType"}, new Object[]{openType, op.getReturnType().getName()}));
        }
        return new MBeanInfo(this.objectName.toString(), "spf4j exported", attrs, null, operations, null);
    }

    public String toString() {
        return "ExportedValuesMBean{exportedValues=" + this.exportedValues + ", exportedOperations=" + this.exportedOperations + ", objectName=" + this.objectName + ", beanInfo=" + this.beanInfo + '}';
    }
}

